package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.stats.rev171113.pcep.session.state;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.stats.rev171113.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.stats.rev171113.ErrorMessagesGrouping;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.stats.rev171113.PcepSessionState;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.stats.rev171113.ReplyTimeGrouping;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.Uint16;
import org.opendaylight.yangtools.yang.common.Uint32;

/**
 * The statistics of PCEP received/sent messages from the PCE point of view.
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>pcep-session-stats</b>
 * <pre>
 * container messages {
 *   uses reply-time-grouping;
 *   leaf received-msg-count {
 *     type uint32;
 *     default 0;
 *   }
 *   leaf sent-msg-count {
 *     type uint32;
 *     default 0;
 *   }
 *   leaf last-sent-msg-timestamp {
 *     type uint32;
 *     default 0;
 *   }
 *   leaf unknown-msg-received {
 *     type uint16;
 *     default 0;
 *   }
 *   uses error-messages-grouping;
 * }
 * </pre>The schema path to identify an instance is
 * <i>pcep-session-statspcep-session-statemessages</i>
 *
 * <p>To create instances of this class use {@link MessagesBuilder}.
 * @see MessagesBuilder
 *
 */
@Generated("mdsal-binding-generator")
public interface Messages
    extends
    ChildOf<PcepSessionState>,
    Augmentable<Messages>,
    ReplyTimeGrouping,
    ErrorMessagesGrouping
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("messages");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.stats.rev171113.pcep.session.state.Messages> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.stats.rev171113.pcep.session.state.Messages.class;
    }
    
    /**
     * Default implementation of {@link Object#hashCode()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent hashing
     * results across all implementations.
     *
     * @param obj Object for which to generate hashCode() result.
     * @return Hash code value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static int bindingHashCode(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.stats.rev171113.pcep.session.state.@NonNull Messages obj) {
        final int prime = 31;
        int result = 1;
        result = prime * result + Objects.hashCode(obj.getErrorMessages());
        result = prime * result + Objects.hashCode(obj.getLastSentMsgTimestamp());
        result = prime * result + Objects.hashCode(obj.getReceivedMsgCount());
        result = prime * result + Objects.hashCode(obj.getReplyTime());
        result = prime * result + Objects.hashCode(obj.getSentMsgCount());
        result = prime * result + Objects.hashCode(obj.getUnknownMsgReceived());
        for (var augmentation : obj.augmentations().values()) {
            result += augmentation.hashCode();
        }
        return result;
    }
    
    /**
     * Default implementation of {@link Object#equals(Object)} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent equality
     * results across all implementations.
     *
     * @param thisObj Object acting as the receiver of equals invocation
     * @param obj Object acting as argument to equals invocation
     * @return True if thisObj and obj are considered equal
     * @throws NullPointerException if {@code thisObj} is null
     */
    static boolean bindingEquals(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.stats.rev171113.pcep.session.state.@NonNull Messages thisObj, final Object obj) {
        if (thisObj == obj) {
            return true;
        }
        final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.stats.rev171113.pcep.session.state.Messages other = CodeHelpers.checkCast(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.stats.rev171113.pcep.session.state.Messages.class, obj);
        if (other == null) {
            return false;
        }
        if (!Objects.equals(thisObj.getLastSentMsgTimestamp(), other.getLastSentMsgTimestamp())) {
            return false;
        }
        if (!Objects.equals(thisObj.getReceivedMsgCount(), other.getReceivedMsgCount())) {
            return false;
        }
        if (!Objects.equals(thisObj.getSentMsgCount(), other.getSentMsgCount())) {
            return false;
        }
        if (!Objects.equals(thisObj.getUnknownMsgReceived(), other.getUnknownMsgReceived())) {
            return false;
        }
        if (!Objects.equals(thisObj.getErrorMessages(), other.getErrorMessages())) {
            return false;
        }
        if (!Objects.equals(thisObj.getReplyTime(), other.getReplyTime())) {
            return false;
        }
        return thisObj.augmentations().equals(other.augmentations());
    }
    
    /**
     * Default implementation of {@link Object#toString()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent string
     * representations across all implementations.
     *
     * @param obj Object for which to generate toString() result.
     * @return {@link String} value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static String bindingToString(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.stats.rev171113.pcep.session.state.@NonNull Messages obj) {
        final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("Messages");
        CodeHelpers.appendValue(helper, "errorMessages", obj.getErrorMessages());
        CodeHelpers.appendValue(helper, "lastSentMsgTimestamp", obj.getLastSentMsgTimestamp());
        CodeHelpers.appendValue(helper, "receivedMsgCount", obj.getReceivedMsgCount());
        CodeHelpers.appendValue(helper, "replyTime", obj.getReplyTime());
        CodeHelpers.appendValue(helper, "sentMsgCount", obj.getSentMsgCount());
        CodeHelpers.appendValue(helper, "unknownMsgReceived", obj.getUnknownMsgReceived());
        CodeHelpers.appendAugmentations(helper, "augmentation", obj);
        return helper.toString();
    }
    
    /**
     * Return receivedMsgCount, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Total number of received PCEP messages.
     *     </code>
     * </pre>
     *
     * @return {@code Uint32} receivedMsgCount, or {@code null} if it is not present.
     *
     */
    Uint32 getReceivedMsgCount();
    
    /**
     * Return receivedMsgCount, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Total number of received PCEP messages.
     *     </code>
     * </pre>
     *
     * @return {@code Uint32} receivedMsgCount, guaranteed to be non-null.
     * @throws NoSuchElementException if receivedMsgCount is not present
     *
     */
    default @NonNull Uint32 requireReceivedMsgCount() {
        return CodeHelpers.require(getReceivedMsgCount(), "receivedmsgcount");
    }
    
    /**
     * Return sentMsgCount, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Total number of sent PCEP messages.
     *     </code>
     * </pre>
     *
     * @return {@code Uint32} sentMsgCount, or {@code null} if it is not present.
     *
     */
    Uint32 getSentMsgCount();
    
    /**
     * Return sentMsgCount, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Total number of sent PCEP messages.
     *     </code>
     * </pre>
     *
     * @return {@code Uint32} sentMsgCount, guaranteed to be non-null.
     * @throws NoSuchElementException if sentMsgCount is not present
     *
     */
    default @NonNull Uint32 requireSentMsgCount() {
        return CodeHelpers.require(getSentMsgCount(), "sentmsgcount");
    }
    
    /**
     * Return lastSentMsgTimestamp, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         The timestamp of last sent message.
     *     </code>
     * </pre>
     *
     * @return {@code Uint32} lastSentMsgTimestamp, or {@code null} if it is not present.
     *
     */
    Uint32 getLastSentMsgTimestamp();
    
    /**
     * Return lastSentMsgTimestamp, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         The timestamp of last sent message.
     *     </code>
     * </pre>
     *
     * @return {@code Uint32} lastSentMsgTimestamp, guaranteed to be non-null.
     * @throws NoSuchElementException if lastSentMsgTimestamp is not present
     *
     */
    default @NonNull Uint32 requireLastSentMsgTimestamp() {
        return CodeHelpers.require(getLastSentMsgTimestamp(), "lastsentmsgtimestamp");
    }
    
    /**
     * Return unknownMsgReceived, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         The number of received unknown messages.
     *     </code>
     * </pre>
     *
     * @return {@code Uint16} unknownMsgReceived, or {@code null} if it is not present.
     *
     */
    Uint16 getUnknownMsgReceived();
    
    /**
     * Return unknownMsgReceived, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         The number of received unknown messages.
     *     </code>
     * </pre>
     *
     * @return {@code Uint16} unknownMsgReceived, guaranteed to be non-null.
     * @throws NoSuchElementException if unknownMsgReceived is not present
     *
     */
    default @NonNull Uint16 requireUnknownMsgReceived() {
        return CodeHelpers.require(getUnknownMsgReceived(), "unknownmsgreceived");
    }

}

