package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.stats.rev171113.pcep.session.state;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.stats.rev171113.ErrorMessagesGrouping;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.stats.rev171113.ReplyTimeGrouping;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.stats.rev171113.error.messages.grouping.ErrorMessages;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.stats.rev171113.reply.time.grouping.ReplyTime;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.Uint16;
import org.opendaylight.yangtools.yang.common.Uint32;

/**
 * Class that builds {@link MessagesBuilder} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     MessagesBuilder createTarget(int fooXyzzy, int barBaz) {
 *         return new MessagesBuilderBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of MessagesBuilder, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization oportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see MessagesBuilder
 * @see Builder
 *
 */
@Generated("mdsal-binding-generator")
public class MessagesBuilder implements Builder<Messages> {

    private ErrorMessages _errorMessages;
    private Uint32 _lastSentMsgTimestamp;
    private Uint32 _receivedMsgCount;
    private ReplyTime _replyTime;
    private Uint32 _sentMsgCount;
    private Uint16 _unknownMsgReceived;


    Map<Class<? extends Augmentation<Messages>>, Augmentation<Messages>> augmentation = Collections.emptyMap();

    public MessagesBuilder() {
    }
    
    
    
    public MessagesBuilder(ReplyTimeGrouping arg) {
        this._replyTime = arg.getReplyTime();
    }
    
    public MessagesBuilder(ErrorMessagesGrouping arg) {
        this._errorMessages = arg.getErrorMessages();
    }

    public MessagesBuilder(Messages base) {
        Map<Class<? extends Augmentation<Messages>>, Augmentation<Messages>> aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._errorMessages = base.getErrorMessages();
        this._lastSentMsgTimestamp = base.getLastSentMsgTimestamp();
        this._receivedMsgCount = base.getReceivedMsgCount();
        this._replyTime = base.getReplyTime();
        this._sentMsgCount = base.getSentMsgCount();
        this._unknownMsgReceived = base.getUnknownMsgReceived();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>ReplyTimeGrouping</li>
     * <li>ErrorMessagesGrouping</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof ReplyTimeGrouping) {
            this._replyTime = ((ReplyTimeGrouping)arg).getReplyTime();
            isValidArg = true;
        }
        if (arg instanceof ErrorMessagesGrouping) {
            this._errorMessages = ((ErrorMessagesGrouping)arg).getErrorMessages();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[ReplyTimeGrouping, ErrorMessagesGrouping]");
    }

    public ErrorMessages getErrorMessages() {
        return _errorMessages;
    }
    
    public Uint32 getLastSentMsgTimestamp() {
        return _lastSentMsgTimestamp;
    }
    
    public Uint32 getReceivedMsgCount() {
        return _receivedMsgCount;
    }
    
    public ReplyTime getReplyTime() {
        return _replyTime;
    }
    
    public Uint32 getSentMsgCount() {
        return _sentMsgCount;
    }
    
    public Uint16 getUnknownMsgReceived() {
        return _unknownMsgReceived;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<Messages>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    public MessagesBuilder setErrorMessages(final ErrorMessages value) {
        this._errorMessages = value;
        return this;
    }
    
    public MessagesBuilder setLastSentMsgTimestamp(final Uint32 value) {
        this._lastSentMsgTimestamp = value;
        return this;
    }
    
    public MessagesBuilder setReceivedMsgCount(final Uint32 value) {
        this._receivedMsgCount = value;
        return this;
    }
    
    public MessagesBuilder setReplyTime(final ReplyTime value) {
        this._replyTime = value;
        return this;
    }
    
    public MessagesBuilder setSentMsgCount(final Uint32 value) {
        this._sentMsgCount = value;
        return this;
    }
    
    public MessagesBuilder setUnknownMsgReceived(final Uint16 value) {
        this._unknownMsgReceived = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public MessagesBuilder addAugmentation(Augmentation<Messages> augmentation) {
        Class<? extends Augmentation<Messages>> augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public MessagesBuilder removeAugmentation(Class<? extends Augmentation<Messages>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public Messages build() {
        return new MessagesImpl(this);
    }

    private static final class MessagesImpl
        extends AbstractAugmentable<Messages>
        implements Messages {
    
        private final ErrorMessages _errorMessages;
        private final Uint32 _lastSentMsgTimestamp;
        private final Uint32 _receivedMsgCount;
        private final ReplyTime _replyTime;
        private final Uint32 _sentMsgCount;
        private final Uint16 _unknownMsgReceived;
    
        MessagesImpl(MessagesBuilder base) {
            super(base.augmentation);
            this._errorMessages = base.getErrorMessages();
            this._lastSentMsgTimestamp = base.getLastSentMsgTimestamp();
            this._receivedMsgCount = base.getReceivedMsgCount();
            this._replyTime = base.getReplyTime();
            this._sentMsgCount = base.getSentMsgCount();
            this._unknownMsgReceived = base.getUnknownMsgReceived();
        }
    
        @Override
        public ErrorMessages getErrorMessages() {
            return _errorMessages;
        }
        
        @Override
        public Uint32 getLastSentMsgTimestamp() {
            return _lastSentMsgTimestamp;
        }
        
        @Override
        public Uint32 getReceivedMsgCount() {
            return _receivedMsgCount;
        }
        
        @Override
        public ReplyTime getReplyTime() {
            return _replyTime;
        }
        
        @Override
        public Uint32 getSentMsgCount() {
            return _sentMsgCount;
        }
        
        @Override
        public Uint16 getUnknownMsgReceived() {
            return _unknownMsgReceived;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = Messages.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return Messages.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return Messages.bindingToString(this);
        }
    }
}
