package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.stats.rev171113.pcep.session.state;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.stats.rev171113.Preferences;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.Uint16;
import org.opendaylight.yangtools.yang.common.Uint8;

/**
 * Class that builds {@link PeerPrefBuilder} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     PeerPrefBuilder createTarget(int fooXyzzy, int barBaz) {
 *         return new PeerPrefBuilderBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of PeerPrefBuilder, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization oportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see PeerPrefBuilder
 * @see Builder
 *
 */
@Generated("mdsal-binding-generator")
public class PeerPrefBuilder implements Builder<PeerPref> {

    private Uint8 _deadtimer;
    private String _ipAddress;
    private Uint8 _keepalive;
    private Uint16 _sessionId;


    Map<Class<? extends Augmentation<PeerPref>>, Augmentation<PeerPref>> augmentation = Collections.emptyMap();

    public PeerPrefBuilder() {
    }
    
    
    
    public PeerPrefBuilder(Preferences arg) {
        this._keepalive = arg.getKeepalive();
        this._deadtimer = arg.getDeadtimer();
        this._ipAddress = arg.getIpAddress();
        this._sessionId = arg.getSessionId();
    }

    public PeerPrefBuilder(PeerPref base) {
        Map<Class<? extends Augmentation<PeerPref>>, Augmentation<PeerPref>> aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._deadtimer = base.getDeadtimer();
        this._ipAddress = base.getIpAddress();
        this._keepalive = base.getKeepalive();
        this._sessionId = base.getSessionId();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>Preferences</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof Preferences) {
            this._keepalive = ((Preferences)arg).getKeepalive();
            this._deadtimer = ((Preferences)arg).getDeadtimer();
            this._ipAddress = ((Preferences)arg).getIpAddress();
            this._sessionId = ((Preferences)arg).getSessionId();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[Preferences]");
    }

    public Uint8 getDeadtimer() {
        return _deadtimer;
    }
    
    public String getIpAddress() {
        return _ipAddress;
    }
    
    public Uint8 getKeepalive() {
        return _keepalive;
    }
    
    public Uint16 getSessionId() {
        return _sessionId;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<PeerPref>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    public PeerPrefBuilder setDeadtimer(final Uint8 value) {
        this._deadtimer = value;
        return this;
    }
    
    public PeerPrefBuilder setIpAddress(final String value) {
        this._ipAddress = value;
        return this;
    }
    
    public PeerPrefBuilder setKeepalive(final Uint8 value) {
        this._keepalive = value;
        return this;
    }
    
    public PeerPrefBuilder setSessionId(final Uint16 value) {
        this._sessionId = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public PeerPrefBuilder addAugmentation(Augmentation<PeerPref> augmentation) {
        Class<? extends Augmentation<PeerPref>> augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public PeerPrefBuilder removeAugmentation(Class<? extends Augmentation<PeerPref>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public PeerPref build() {
        return new PeerPrefImpl(this);
    }

    private static final class PeerPrefImpl
        extends AbstractAugmentable<PeerPref>
        implements PeerPref {
    
        private final Uint8 _deadtimer;
        private final String _ipAddress;
        private final Uint8 _keepalive;
        private final Uint16 _sessionId;
    
        PeerPrefImpl(PeerPrefBuilder base) {
            super(base.augmentation);
            this._deadtimer = base.getDeadtimer();
            this._ipAddress = base.getIpAddress();
            this._keepalive = base.getKeepalive();
            this._sessionId = base.getSessionId();
        }
    
        @Override
        public Uint8 getDeadtimer() {
            return _deadtimer;
        }
        
        @Override
        public String getIpAddress() {
            return _ipAddress;
        }
        
        @Override
        public Uint8 getKeepalive() {
            return _keepalive;
        }
        
        @Override
        public Uint16 getSessionId() {
            return _sessionId;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = PeerPref.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return PeerPref.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return PeerPref.bindingToString(this);
        }
    }
}
