package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.stats.rev171113.pcep.session.state.grouping;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.stats.rev171113.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.stats.rev171113.PcepSessionStateGrouping;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>pcep-session-stats</b>
 * <pre>
 * container pcep-session-state {
 *   uses pcep-session-state;
 * }
 * </pre>The schema path to identify an instance is
 * <i>pcep-session-statspcep-session-state-groupingpcep-session-state</i>
 *
 * <p>To create instances of this class use {@link PcepSessionStateBuilder}.
 * @see PcepSessionStateBuilder
 *
 */
@Generated("mdsal-binding-generator")
public interface PcepSessionState
    extends
    ChildOf<PcepSessionStateGrouping>,
    Augmentable<PcepSessionState>,
    org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.stats.rev171113.PcepSessionState
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("pcep-session-state");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.stats.rev171113.pcep.session.state.grouping.PcepSessionState> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.stats.rev171113.pcep.session.state.grouping.PcepSessionState.class;
    }
    
    /**
     * Default implementation of {@link Object#hashCode()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent hashing
     * results across all implementations.
     *
     * @param obj Object for which to generate hashCode() result.
     * @return Hash code value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static int bindingHashCode(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.stats.rev171113.pcep.session.state.grouping.@NonNull PcepSessionState obj) {
        final int prime = 31;
        int result = 1;
        result = prime * result + Objects.hashCode(obj.getDelegatedLspsCount());
        result = prime * result + Objects.hashCode(obj.getLocalPref());
        result = prime * result + Objects.hashCode(obj.getMessages());
        result = prime * result + Objects.hashCode(obj.getPeerCapabilities());
        result = prime * result + Objects.hashCode(obj.getPeerPref());
        result = prime * result + Objects.hashCode(obj.getSessionDuration());
        result = prime * result + Objects.hashCode(obj.getSynchronized());
        for (var augmentation : obj.augmentations().values()) {
            result += augmentation.hashCode();
        }
        return result;
    }
    
    /**
     * Default implementation of {@link Object#equals(Object)} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent equality
     * results across all implementations.
     *
     * @param thisObj Object acting as the receiver of equals invocation
     * @param obj Object acting as argument to equals invocation
     * @return True if thisObj and obj are considered equal
     * @throws NullPointerException if {@code thisObj} is null
     */
    static boolean bindingEquals(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.stats.rev171113.pcep.session.state.grouping.@NonNull PcepSessionState thisObj, final Object obj) {
        if (thisObj == obj) {
            return true;
        }
        final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.stats.rev171113.pcep.session.state.grouping.PcepSessionState other = CodeHelpers.checkCast(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.stats.rev171113.pcep.session.state.grouping.PcepSessionState.class, obj);
        if (other == null) {
            return false;
        }
        if (!Objects.equals(thisObj.getDelegatedLspsCount(), other.getDelegatedLspsCount())) {
            return false;
        }
        if (!Objects.equals(thisObj.getSynchronized(), other.getSynchronized())) {
            return false;
        }
        if (!Objects.equals(thisObj.getSessionDuration(), other.getSessionDuration())) {
            return false;
        }
        if (!Objects.equals(thisObj.getLocalPref(), other.getLocalPref())) {
            return false;
        }
        if (!Objects.equals(thisObj.getMessages(), other.getMessages())) {
            return false;
        }
        if (!Objects.equals(thisObj.getPeerCapabilities(), other.getPeerCapabilities())) {
            return false;
        }
        if (!Objects.equals(thisObj.getPeerPref(), other.getPeerPref())) {
            return false;
        }
        return thisObj.augmentations().equals(other.augmentations());
    }
    
    /**
     * Default implementation of {@link Object#toString()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent string
     * representations across all implementations.
     *
     * @param obj Object for which to generate toString() result.
     * @return {@link String} value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static String bindingToString(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.stats.rev171113.pcep.session.state.grouping.@NonNull PcepSessionState obj) {
        final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("PcepSessionState");
        CodeHelpers.appendValue(helper, "delegatedLspsCount", obj.getDelegatedLspsCount());
        CodeHelpers.appendValue(helper, "localPref", obj.getLocalPref());
        CodeHelpers.appendValue(helper, "messages", obj.getMessages());
        CodeHelpers.appendValue(helper, "peerCapabilities", obj.getPeerCapabilities());
        CodeHelpers.appendValue(helper, "peerPref", obj.getPeerPref());
        CodeHelpers.appendValue(helper, "sessionDuration", obj.getSessionDuration());
        CodeHelpers.appendValue(helper, "synchronized", obj.getSynchronized());
        CodeHelpers.appendAugmentations(helper, "augmentation", obj);
        return helper.toString();
    }

}

