package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.stats.rev171113.reply.time.grouping;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.stats.rev171113.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.stats.rev171113.ReplyTimeGrouping;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.Uint32;

/**
 * Measures time elapsed from request's send to reply's received.
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>pcep-session-stats</b>
 * <pre>
 * container reply-time {
 *   leaf average-time {
 *     type uint32;
 *     default 0;
 *   }
 *   leaf min-time {
 *     type uint32;
 *     default 0;
 *   }
 *   leaf max-time {
 *     type uint32;
 *     default 0;
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>pcep-session-statsreply-time-groupingreply-time</i>
 *
 * <p>To create instances of this class use {@link ReplyTimeBuilder}.
 * @see ReplyTimeBuilder
 *
 */
@Generated("mdsal-binding-generator")
public interface ReplyTime
    extends
    ChildOf<ReplyTimeGrouping>,
    Augmentable<ReplyTime>
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("reply-time");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.stats.rev171113.reply.time.grouping.ReplyTime> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.stats.rev171113.reply.time.grouping.ReplyTime.class;
    }
    
    /**
     * Default implementation of {@link Object#hashCode()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent hashing
     * results across all implementations.
     *
     * @param obj Object for which to generate hashCode() result.
     * @return Hash code value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static int bindingHashCode(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.stats.rev171113.reply.time.grouping.@NonNull ReplyTime obj) {
        final int prime = 31;
        int result = 1;
        result = prime * result + Objects.hashCode(obj.getAverageTime());
        result = prime * result + Objects.hashCode(obj.getMaxTime());
        result = prime * result + Objects.hashCode(obj.getMinTime());
        for (var augmentation : obj.augmentations().values()) {
            result += augmentation.hashCode();
        }
        return result;
    }
    
    /**
     * Default implementation of {@link Object#equals(Object)} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent equality
     * results across all implementations.
     *
     * @param thisObj Object acting as the receiver of equals invocation
     * @param obj Object acting as argument to equals invocation
     * @return True if thisObj and obj are considered equal
     * @throws NullPointerException if {@code thisObj} is null
     */
    static boolean bindingEquals(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.stats.rev171113.reply.time.grouping.@NonNull ReplyTime thisObj, final Object obj) {
        if (thisObj == obj) {
            return true;
        }
        final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.stats.rev171113.reply.time.grouping.ReplyTime other = CodeHelpers.checkCast(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.stats.rev171113.reply.time.grouping.ReplyTime.class, obj);
        if (other == null) {
            return false;
        }
        if (!Objects.equals(thisObj.getAverageTime(), other.getAverageTime())) {
            return false;
        }
        if (!Objects.equals(thisObj.getMaxTime(), other.getMaxTime())) {
            return false;
        }
        if (!Objects.equals(thisObj.getMinTime(), other.getMinTime())) {
            return false;
        }
        return thisObj.augmentations().equals(other.augmentations());
    }
    
    /**
     * Default implementation of {@link Object#toString()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent string
     * representations across all implementations.
     *
     * @param obj Object for which to generate toString() result.
     * @return {@link String} value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static String bindingToString(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.stats.rev171113.reply.time.grouping.@NonNull ReplyTime obj) {
        final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("ReplyTime");
        CodeHelpers.appendValue(helper, "averageTime", obj.getAverageTime());
        CodeHelpers.appendValue(helper, "maxTime", obj.getMaxTime());
        CodeHelpers.appendValue(helper, "minTime", obj.getMinTime());
        CodeHelpers.appendAugmentations(helper, "augmentation", obj);
        return helper.toString();
    }
    
    /**
     * Return averageTime, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Average time (in milliseconds) of gauged values.
     *     </code>
     * </pre>
     *
     * @return {@code Uint32} averageTime, or {@code null} if it is not present.
     *
     */
    Uint32 getAverageTime();
    
    /**
     * Return averageTime, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Average time (in milliseconds) of gauged values.
     *     </code>
     * </pre>
     *
     * @return {@code Uint32} averageTime, guaranteed to be non-null.
     * @throws NoSuchElementException if averageTime is not present
     *
     */
    default @NonNull Uint32 requireAverageTime() {
        return CodeHelpers.require(getAverageTime(), "averagetime");
    }
    
    /**
     * Return minTime, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Minimal measured time value (in milliseconds).
     *     </code>
     * </pre>
     *
     * @return {@code Uint32} minTime, or {@code null} if it is not present.
     *
     */
    Uint32 getMinTime();
    
    /**
     * Return minTime, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Minimal measured time value (in milliseconds).
     *     </code>
     * </pre>
     *
     * @return {@code Uint32} minTime, guaranteed to be non-null.
     * @throws NoSuchElementException if minTime is not present
     *
     */
    default @NonNull Uint32 requireMinTime() {
        return CodeHelpers.require(getMinTime(), "mintime");
    }
    
    /**
     * Return maxTime, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Maximal measured time value (in milliseconds).
     *     </code>
     * </pre>
     *
     * @return {@code Uint32} maxTime, or {@code null} if it is not present.
     *
     */
    Uint32 getMaxTime();
    
    /**
     * Return maxTime, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Maximal measured time value (in milliseconds).
     *     </code>
     * </pre>
     *
     * @return {@code Uint32} maxTime, guaranteed to be non-null.
     * @throws NoSuchElementException if maxTime is not present
     *
     */
    default @NonNull Uint32 requireMaxTime() {
        return CodeHelpers.require(getMaxTime(), "maxtime");
    }

}

