package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.stats.rev171113.reply.time.grouping;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.common.Uint32;

/**
 * Class that builds {@link ReplyTimeBuilder} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     ReplyTimeBuilder createTarget(int fooXyzzy, int barBaz) {
 *         return new ReplyTimeBuilderBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of ReplyTimeBuilder, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization oportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see ReplyTimeBuilder
 * @see Builder
 *
 */
@Generated("mdsal-binding-generator")
public class ReplyTimeBuilder implements Builder<ReplyTime> {

    private Uint32 _averageTime;
    private Uint32 _maxTime;
    private Uint32 _minTime;


    Map<Class<? extends Augmentation<ReplyTime>>, Augmentation<ReplyTime>> augmentation = Collections.emptyMap();

    public ReplyTimeBuilder() {
    }
    
    

    public ReplyTimeBuilder(ReplyTime base) {
        Map<Class<? extends Augmentation<ReplyTime>>, Augmentation<ReplyTime>> aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._averageTime = base.getAverageTime();
        this._maxTime = base.getMaxTime();
        this._minTime = base.getMinTime();
    }


    public Uint32 getAverageTime() {
        return _averageTime;
    }
    
    public Uint32 getMaxTime() {
        return _maxTime;
    }
    
    public Uint32 getMinTime() {
        return _minTime;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<ReplyTime>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    public ReplyTimeBuilder setAverageTime(final Uint32 value) {
        this._averageTime = value;
        return this;
    }
    
    public ReplyTimeBuilder setMaxTime(final Uint32 value) {
        this._maxTime = value;
        return this;
    }
    
    public ReplyTimeBuilder setMinTime(final Uint32 value) {
        this._minTime = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public ReplyTimeBuilder addAugmentation(Augmentation<ReplyTime> augmentation) {
        Class<? extends Augmentation<ReplyTime>> augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public ReplyTimeBuilder removeAugmentation(Class<? extends Augmentation<ReplyTime>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public ReplyTime build() {
        return new ReplyTimeImpl(this);
    }

    private static final class ReplyTimeImpl
        extends AbstractAugmentable<ReplyTime>
        implements ReplyTime {
    
        private final Uint32 _averageTime;
        private final Uint32 _maxTime;
        private final Uint32 _minTime;
    
        ReplyTimeImpl(ReplyTimeBuilder base) {
            super(base.augmentation);
            this._averageTime = base.getAverageTime();
            this._maxTime = base.getMaxTime();
            this._minTime = base.getMinTime();
        }
    
        @Override
        public Uint32 getAverageTime() {
            return _averageTime;
        }
        
        @Override
        public Uint32 getMaxTime() {
            return _maxTime;
        }
        
        @Override
        public Uint32 getMinTime() {
            return _minTime;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = ReplyTime.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return ReplyTime.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return ReplyTime.bindingToString(this);
        }
    }
}
