package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109;
import java.lang.Class;
import java.lang.Override;
import java.util.NoSuchElementException;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv4AddressNoZone;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>pcep-types</b>
 * <pre>
 * grouping endpoints-ipv4-source {
 *   leaf source-ipv4-address {
 *     type inet:ipv4-address-no-zone;
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>pcep-typesendpoints-ipv4-source</i>
 *
 */
@Generated("mdsal-binding-generator")
public interface EndpointsIpv4Source
    extends
    DataObject
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("endpoints-ipv4-source");

    @Override
    Class<? extends EndpointsIpv4Source> implementedInterface();
    
    /**
     * Return sourceIpv4Address, or {@code null} if it is not present.
     *
     * @return {@code Ipv4AddressNoZone} sourceIpv4Address, or {@code null} if it is not present.
     *
     */
    Ipv4AddressNoZone getSourceIpv4Address();
    
    /**
     * Return sourceIpv4Address, guaranteed to be non-null.
     *
     * @return {@code Ipv4AddressNoZone} sourceIpv4Address, guaranteed to be non-null.
     * @throws NoSuchElementException if sourceIpv4Address is not present
     *
     */
    default @NonNull Ipv4AddressNoZone requireSourceIpv4Address() {
        return CodeHelpers.require(getSourceIpv4Address(), "sourceipv4address");
    }

}

