package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109;
import java.lang.Class;
import java.lang.Override;
import java.util.NoSuchElementException;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv6AddressNoZone;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>pcep-types</b>
 * <pre>
 * grouping endpoints-ipv6-source {
 *   leaf source-ipv6-address {
 *     type inet:ipv6-address-no-zone;
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>pcep-typesendpoints-ipv6-source</i>
 *
 */
@Generated("mdsal-binding-generator")
public interface EndpointsIpv6Source
    extends
    DataObject
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("endpoints-ipv6-source");

    @Override
    Class<? extends EndpointsIpv6Source> implementedInterface();
    
    /**
     * Return sourceIpv6Address, or {@code null} if it is not present.
     *
     * @return {@code Ipv6AddressNoZone} sourceIpv6Address, or {@code null} if it is not present.
     *
     */
    Ipv6AddressNoZone getSourceIpv6Address();
    
    /**
     * Return sourceIpv6Address, guaranteed to be non-null.
     *
     * @return {@code Ipv6AddressNoZone} sourceIpv6Address, guaranteed to be non-null.
     * @throws NoSuchElementException if sourceIpv6Address is not present
     *
     */
    default @NonNull Ipv6AddressNoZone requireSourceIpv6Address() {
        return CodeHelpers.require(getSourceIpv6Address(), "sourceipv6address");
    }

}

