package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109;
import java.lang.Class;
import java.lang.Override;
import java.util.List;
import java.util.NoSuchElementException;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv4AddressNoZone;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>pcep-types</b>
 * <pre>
 * grouping ipv4-destinations {
 *   leaf-list destination-ipv4-address {
 *     type inet:ipv4-address-no-zone;
 *     min-elements 1;
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>pcep-typesipv4-destinations</i>
 *
 */
@Generated("mdsal-binding-generator")
public interface Ipv4Destinations
    extends
    DataObject
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("ipv4-destinations");

    @Override
    Class<? extends Ipv4Destinations> implementedInterface();
    
    /**
     * Return destinationIpv4Address, or {@code null} if it is not present.
     *
     * @return {@code List<Ipv4AddressNoZone>} destinationIpv4Address, or {@code null} if it is not present.
     *
     */
    @Nullable List<Ipv4AddressNoZone> getDestinationIpv4Address();
    
    /**
     * Return destinationIpv4Address, guaranteed to be non-null.
     *
     * @return {@code List<Ipv4AddressNoZone>} destinationIpv4Address, guaranteed to be non-null.
     * @throws NoSuchElementException if destinationIpv4Address is not present
     *
     */
    default @NonNull List<Ipv4AddressNoZone> requireDestinationIpv4Address() {
        return CodeHelpers.require(getDestinationIpv4Address(), "destinationipv4address");
    }

}

