package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109;
import java.lang.Class;
import java.lang.Override;
import java.util.List;
import java.util.NoSuchElementException;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv6AddressNoZone;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>pcep-types</b>
 * <pre>
 * grouping ipv6-destinations {
 *   leaf-list destination-ipv6-address {
 *     type inet:ipv6-address-no-zone;
 *     min-elements 1;
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>pcep-typesipv6-destinations</i>
 *
 */
@Generated("mdsal-binding-generator")
public interface Ipv6Destinations
    extends
    DataObject
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("ipv6-destinations");

    @Override
    Class<? extends Ipv6Destinations> implementedInterface();
    
    /**
     * Return destinationIpv6Address, or {@code null} if it is not present.
     *
     * @return {@code List<Ipv6AddressNoZone>} destinationIpv6Address, or {@code null} if it is not present.
     *
     */
    @Nullable List<Ipv6AddressNoZone> getDestinationIpv6Address();
    
    /**
     * Return destinationIpv6Address, guaranteed to be non-null.
     *
     * @return {@code List<Ipv6AddressNoZone>} destinationIpv6Address, guaranteed to be non-null.
     * @throws NoSuchElementException if destinationIpv6Address is not present
     *
     */
    default @NonNull List<Ipv6AddressNoZone> requireDestinationIpv6Address() {
        return CodeHelpers.require(getDestinationIpv6Address(), "destinationipv6address");
    }

}

