package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109;
import java.lang.Class;
import java.lang.Override;
import java.util.List;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.lsp.attributes.Metrics;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>pcep-types</b>
 * <pre>
 * grouping lsp-attributes {
 *   uses lspa-object;
 *   uses bandwidth-object;
 *   uses reoptimization-bandwidth-object;
 *   list metrics {
 *     uses metric-object;
 *   }
 *   uses include-route-object;
 *   uses reported-route-object;
 *   uses exclude-route-object;
 *   uses of-object;
 *   uses classtype-object;
 * }
 * </pre>The schema path to identify an instance is
 * <i>pcep-typeslsp-attributes</i>
 *
 */
@Generated("mdsal-binding-generator")
public interface LspAttributes
    extends
    DataObject,
    LspaObject,
    BandwidthObject,
    ReoptimizationBandwidthObject,
    IncludeRouteObject,
    ReportedRouteObject,
    ExcludeRouteObject,
    OfObject,
    ClasstypeObject
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("lsp-attributes");

    @Override
    Class<? extends LspAttributes> implementedInterface();
    
    /**
     * Return metrics, or {@code null} if it is not present.
     *
     * @return {@code List<Metrics>} metrics, or {@code null} if it is not present.
     *
     */
    @Nullable List<Metrics> getMetrics();
    
    /**
     * Return metrics, or an empty list if it is not present.
     *
     * @return {@code List<Metrics>} metrics, or an empty list if it is not present.
     *
     */
    default @NonNull List<Metrics> nonnullMetrics() {
        return CodeHelpers.nonnull(getMetrics());
    }

}

