package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109;
import java.lang.Class;
import java.lang.Override;
import java.util.NoSuchElementException;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Common Header
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>pcep-types</b>
 * <pre>
 * grouping message-header {
 *   leaf version {
 *     type protocol-version;
 *     default 1;
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>pcep-typesmessage-header</i>
 *
 */
@Generated("mdsal-binding-generator")
public interface MessageHeader
    extends
    DataObject
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("message-header");

    @Override
    Class<? extends MessageHeader> implementedInterface();
    
    /**
     * Return version, or {@code null} if it is not present.
     *
     * @return {@code ProtocolVersion} version, or {@code null} if it is not present.
     *
     */
    ProtocolVersion getVersion();
    
    /**
     * Return version, guaranteed to be non-null.
     *
     * @return {@code ProtocolVersion} version, guaranteed to be non-null.
     * @throws NoSuchElementException if version is not present
     *
     */
    default @NonNull ProtocolVersion requireVersion() {
        return CodeHelpers.require(getVersion(), "version");
    }

}

