package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109;
import java.lang.Class;
import java.lang.Override;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.monitoring.object.Monitoring;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * The MONITORING object is used to specify the set of requested PCEP state 
 * metrics.
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>pcep-types</b>
 * <pre>
 * grouping monitoring-object {
 *   container monitoring {
 *     uses object;
 *     leaf flags {
 *       type bits {
 *         bit incomplete {
 *           position 19;
 *         }
 *         bit overload {
 *           position 20;
 *         }
 *         bit processing-time {
 *           position 21;
 *         }
 *         bit general {
 *           position 22;
 *         }
 *         bit liveness {
 *           position 23;
 *         }
 *       }
 *     }
 *     leaf monitoring-id {
 *       type uint32;
 *     }
 *     container tlvs {
 *       uses vendor-information-tlvs;
 *     }
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>pcep-typesmonitoring-object</i>
 *
 */
@Generated("mdsal-binding-generator")
public interface MonitoringObject
    extends
    DataObject
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("monitoring-object");

    @Override
    Class<? extends MonitoringObject> implementedInterface();
    
    /**
     * Return monitoring, or {@code null} if it is not present.
     *
     * @return {@code Monitoring} monitoring, or {@code null} if it is not present.
     *
     */
    Monitoring getMonitoring();

}

