package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109;
import java.lang.Boolean;
import java.lang.Class;
import java.lang.Override;
import java.util.NoSuchElementException;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.Uint8;

/**
 * NO-PATH Object
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>pcep-types</b>
 * <pre>
 * grouping no-path-object {
 *   uses object;
 *   leaf nature-of-issue {
 *     type uint8;
 *   }
 *   leaf unsatisfied-constraints {
 *     when "nature-of-issue = 0" {
 *     }
 *     type boolean;
 *     default false;
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>pcep-typesno-path-object</i>
 *
 */
@Generated("mdsal-binding-generator")
public interface NoPathObject
    extends
    DataObject,
    Object
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("no-path-object");

    @Override
    Class<? extends NoPathObject> implementedInterface();
    
    /**
     * Return natureOfIssue, or {@code null} if it is not present.
     *
     * @return {@code Uint8} natureOfIssue, or {@code null} if it is not present.
     *
     */
    Uint8 getNatureOfIssue();
    
    /**
     * Return natureOfIssue, guaranteed to be non-null.
     *
     * @return {@code Uint8} natureOfIssue, guaranteed to be non-null.
     * @throws NoSuchElementException if natureOfIssue is not present
     *
     */
    default @NonNull Uint8 requireNatureOfIssue() {
        return CodeHelpers.require(getNatureOfIssue(), "natureofissue");
    }
    
    /**
     * Return unsatisfiedConstraints, or {@code null} if it is not present.
     *
     * @return {@code Boolean} unsatisfiedConstraints, or {@code null} if it is not present.
     *
     */
    Boolean getUnsatisfiedConstraints();
    
    /**
     * Return unsatisfiedConstraints, guaranteed to be non-null.
     *
     * @return {@code Boolean} unsatisfiedConstraints, guaranteed to be non-null.
     * @throws NoSuchElementException if unsatisfiedConstraints is not present
     *
     */
    default @NonNull Boolean requireUnsatisfiedConstraints() {
        return CodeHelpers.require(getUnsatisfiedConstraints(), "unsatisfiedconstraints");
    }

}

