package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109;
import com.google.common.base.MoreObjects;
import java.io.Serializable;
import java.lang.Boolean;
import java.lang.Class;
import java.lang.Override;
import java.lang.String;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.TypeObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * NO-PATH-VECTOR TLV
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>pcep-types</b>
 * <pre>
 * grouping no-path-vector-tlv {
 *   uses tlv;
 *   leaf flags {
 *     type bits {
 *       bit p2mp-unreachable {
 *         position 24;
 *       }
 *       bit no-gco-solution {
 *         position 25;
 *       }
 *       bit no-gco-migration {
 *         position 26;
 *       }
 *       bit path-key {
 *         position 27;
 *       }
 *       bit chain-unavailable {
 *         position 28;
 *       }
 *       bit unknown-source {
 *         position 29;
 *       }
 *       bit unknown-destination {
 *         position 30;
 *       }
 *       bit pce-unavailable {
 *         position 31;
 *       }
 *     }
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>pcep-typesno-path-vector-tlv</i>
 *
 */
@Generated("mdsal-binding-generator")
public interface NoPathVectorTlv
    extends
    DataObject,
    Tlv
{

    public static final class Flags
     implements TypeObject, Serializable {
        private static final long serialVersionUID = -5886784865235221091L;
        private final Boolean _p2mpUnreachable;
        private final Boolean _noGcoSolution;
        private final Boolean _noGcoMigration;
        private final Boolean _pathKey;
        private final Boolean _chainUnavailable;
        private final Boolean _unknownSource;
        private final Boolean _unknownDestination;
        private final Boolean _pceUnavailable;
    
    
        public Flags(Boolean _chainUnavailable, Boolean _noGcoMigration, Boolean _noGcoSolution, Boolean _p2mpUnreachable, Boolean _pathKey, Boolean _pceUnavailable, Boolean _unknownDestination, Boolean _unknownSource) {
        
            this._p2mpUnreachable = _p2mpUnreachable;
            this._noGcoSolution = _noGcoSolution;
            this._noGcoMigration = _noGcoMigration;
            this._pathKey = _pathKey;
            this._chainUnavailable = _chainUnavailable;
            this._unknownSource = _unknownSource;
            this._unknownDestination = _unknownDestination;
            this._pceUnavailable = _pceUnavailable;
        }
        
        /**
         * Creates a copy from Source Object.
         *
         * @param source Source object
         */
        public Flags(Flags source) {
            this._p2mpUnreachable = source._p2mpUnreachable;
            this._noGcoSolution = source._noGcoSolution;
            this._noGcoMigration = source._noGcoMigration;
            this._pathKey = source._pathKey;
            this._chainUnavailable = source._chainUnavailable;
            this._unknownSource = source._unknownSource;
            this._unknownDestination = source._unknownDestination;
            this._pceUnavailable = source._pceUnavailable;
        }
    
    
        public Boolean getP2mpUnreachable() {
            return _p2mpUnreachable;
        }
        
        public Boolean getNoGcoSolution() {
            return _noGcoSolution;
        }
        
        public Boolean getNoGcoMigration() {
            return _noGcoMigration;
        }
        
        public Boolean getPathKey() {
            return _pathKey;
        }
        
        public Boolean getChainUnavailable() {
            return _chainUnavailable;
        }
        
        public Boolean getUnknownSource() {
            return _unknownSource;
        }
        
        public Boolean getUnknownDestination() {
            return _unknownDestination;
        }
        
        public Boolean getPceUnavailable() {
            return _pceUnavailable;
        }
    
    
        @Override
        public int hashCode() {
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_p2mpUnreachable);
            result = prime * result + Objects.hashCode(_noGcoSolution);
            result = prime * result + Objects.hashCode(_noGcoMigration);
            result = prime * result + Objects.hashCode(_pathKey);
            result = prime * result + Objects.hashCode(_chainUnavailable);
            result = prime * result + Objects.hashCode(_unknownSource);
            result = prime * result + Objects.hashCode(_unknownDestination);
            result = prime * result + Objects.hashCode(_pceUnavailable);
            return result;
        }
    
        @Override
        public final boolean equals(java.lang.Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof Flags)) {
                return false;
            }
            final Flags other = (Flags) obj;
            if (!Objects.equals(_p2mpUnreachable, other._p2mpUnreachable)) {
                return false;
            }
            if (!Objects.equals(_noGcoSolution, other._noGcoSolution)) {
                return false;
            }
            if (!Objects.equals(_noGcoMigration, other._noGcoMigration)) {
                return false;
            }
            if (!Objects.equals(_pathKey, other._pathKey)) {
                return false;
            }
            if (!Objects.equals(_chainUnavailable, other._chainUnavailable)) {
                return false;
            }
            if (!Objects.equals(_unknownSource, other._unknownSource)) {
                return false;
            }
            if (!Objects.equals(_unknownDestination, other._unknownDestination)) {
                return false;
            }
            if (!Objects.equals(_pceUnavailable, other._pceUnavailable)) {
                return false;
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper(Flags.class);
            CodeHelpers.appendValue(helper, "_p2mpUnreachable", _p2mpUnreachable);
            CodeHelpers.appendValue(helper, "_noGcoSolution", _noGcoSolution);
            CodeHelpers.appendValue(helper, "_noGcoMigration", _noGcoMigration);
            CodeHelpers.appendValue(helper, "_pathKey", _pathKey);
            CodeHelpers.appendValue(helper, "_chainUnavailable", _chainUnavailable);
            CodeHelpers.appendValue(helper, "_unknownSource", _unknownSource);
            CodeHelpers.appendValue(helper, "_unknownDestination", _unknownDestination);
            CodeHelpers.appendValue(helper, "_pceUnavailable", _pceUnavailable);
            return helper.toString();
        }
    }
    


    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("no-path-vector-tlv");

    @Override
    Class<? extends NoPathVectorTlv> implementedInterface();
    
    /**
     * Return flags, or {@code null} if it is not present.
     *
     * @return {@code Flags} flags, or {@code null} if it is not present.
     *
     */
    Flags getFlags();
    
    /**
     * Return flags, guaranteed to be non-null.
     *
     * @return {@code Flags} flags, guaranteed to be non-null.
     * @throws NoSuchElementException if flags is not present
     *
     */
    default @NonNull Flags requireFlags() {
        return CodeHelpers.require(getFlags(), "flags");
    }

}

