package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109;
import java.lang.Boolean;
import java.lang.Class;
import java.lang.Override;
import java.util.NoSuchElementException;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Common Object Header
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>pcep-types</b>
 * <pre>
 * grouping object-header {
 *   leaf processing-rule {
 *     type boolean;
 *     default false;
 *   }
 *   leaf ignore {
 *     type boolean;
 *     default false;
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>pcep-typesobject-header</i>
 *
 */
@Generated("mdsal-binding-generator")
public interface ObjectHeader
    extends
    DataObject
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("object-header");

    @Override
    Class<? extends ObjectHeader> implementedInterface();
    
    /**
     * Return processingRule, or {@code null} if it is not present.
     *
     * @return {@code Boolean} processingRule, or {@code null} if it is not present.
     *
     */
    Boolean getProcessingRule();
    
    /**
     * Return processingRule, guaranteed to be non-null.
     *
     * @return {@code Boolean} processingRule, guaranteed to be non-null.
     * @throws NoSuchElementException if processingRule is not present
     *
     */
    default @NonNull Boolean requireProcessingRule() {
        return CodeHelpers.require(getProcessingRule(), "processingrule");
    }
    
    /**
     * Return ignore, or {@code null} if it is not present.
     *
     * @return {@code Boolean} ignore, or {@code null} if it is not present.
     *
     */
    Boolean getIgnore();
    
    /**
     * Return ignore, guaranteed to be non-null.
     *
     * @return {@code Boolean} ignore, guaranteed to be non-null.
     * @throws NoSuchElementException if ignore is not present
     *
     */
    default @NonNull Boolean requireIgnore() {
        return CodeHelpers.require(getIgnore(), "ignore");
    }

}

