package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109;
import java.lang.Class;
import java.lang.Override;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.proc.time.object.ProcTime;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * The PROC-TIME object is used to report various processing time related metrics.
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>pcep-types</b>
 * <pre>
 * grouping proc-time-object {
 *   container proc-time {
 *     uses object;
 *     leaf estimated {
 *       type boolean;
 *     }
 *     leaf current-proc-time {
 *       type uint32;
 *     }
 *     leaf min-proc-time {
 *       type uint32;
 *     }
 *     leaf max-proc-time {
 *       type uint32;
 *     }
 *     leaf average-proc-time {
 *       type uint32;
 *     }
 *     leaf variance-proc-time {
 *       type uint32;
 *     }
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>pcep-typesproc-time-object</i>
 *
 */
@Generated("mdsal-binding-generator")
public interface ProcTimeObject
    extends
    DataObject
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("proc-time-object");

    @Override
    Class<? extends ProcTimeObject> implementedInterface();
    
    /**
     * Return procTime, or {@code null} if it is not present.
     *
     * @return {@code ProcTime} procTime, or {@code null} if it is not present.
     *
     */
    ProcTime getProcTime();

}

