package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109;
import com.google.common.base.MoreObjects;
import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;
import javax.annotation.processing.Generated;
import javax.management.ConstructorParameters;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.ScalarTypeObject;
import org.opendaylight.yangtools.yang.common.Uint32;

@Generated("mdsal-binding-generator")
public class RequestId
 implements ScalarTypeObject<Uint32>, Serializable {
    private static final long serialVersionUID = 3068263630509172403L;
    private final Uint32 _value;

    private static void check_valueRange(final long value) {
        if (value >= 1L) {
            return;
        }
        CodeHelpers.throwInvalidRange("[[1..4294967295]]", value);
    }

    @ConstructorParameters("value")
    @ConstructorProperties("value")
    public RequestId(Uint32 _value) {
        if (_value != null) {
            check_valueRange(_value.longValue());
        }
        
        CodeHelpers.requireValue(_value);
    
        this._value = _value;
    }
    
    /**
     * Creates a copy from Source Object.
     *
     * @param source Source object
     */
    public RequestId(RequestId source) {
        this._value = source._value;
    }

    public static RequestId getDefaultInstance(final String defaultValue) {
        return new RequestId(Uint32.valueOf(defaultValue));
    }

    @Override
    public Uint32 getValue() {
        return _value;
    }


    @Override
    public int hashCode() {
        return CodeHelpers.wrapperHashCode(_value);
    }

    @Override
    public final boolean equals(java.lang.Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof RequestId)) {
            return false;
        }
        final RequestId other = (RequestId) obj;
        if (!Objects.equals(_value, other._value)) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper(RequestId.class);
        CodeHelpers.appendValue(helper, "_value", _value);
        return helper.toString();
    }
}

