package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109;
import java.lang.Class;
import java.lang.Override;
import java.util.NoSuchElementException;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.iana.rev130816.EnterpriseNumber;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.vendor.information.EnterpriseSpecificInformation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * VENDOR-INFORMATION format
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>pcep-types</b>
 * <pre>
 * grouping vendor-information {
 *   leaf enterprise-number {
 *     type iana:enterprise-number;
 *   }
 *   choice enterprise-specific-information;
 * }
 * </pre>The schema path to identify an instance is
 * <i>pcep-typesvendor-information</i>
 *
 */
@Generated("mdsal-binding-generator")
public interface VendorInformation
    extends
    DataObject
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("vendor-information");

    @Override
    Class<? extends VendorInformation> implementedInterface();
    
    /**
     * Return enterpriseNumber, or {@code null} if it is not present.
     *
     * @return {@code EnterpriseNumber} enterpriseNumber, or {@code null} if it is not present.
     *
     */
    EnterpriseNumber getEnterpriseNumber();
    
    /**
     * Return enterpriseNumber, guaranteed to be non-null.
     *
     * @return {@code EnterpriseNumber} enterpriseNumber, guaranteed to be non-null.
     * @throws NoSuchElementException if enterpriseNumber is not present
     *
     */
    default @NonNull EnterpriseNumber requireEnterpriseNumber() {
        return CodeHelpers.require(getEnterpriseNumber(), "enterprisenumber");
    }
    
    /**
     * Return enterpriseSpecificInformation, or {@code null} if it is not present.
     *
     * @return {@code EnterpriseSpecificInformation} enterpriseSpecificInformation, or {@code null} if it is not present.
     *
     */
    EnterpriseSpecificInformation getEnterpriseSpecificInformation();

}

