package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.bnc.object.branch.node.type;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.NonBranchNodeObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.non.branch.node.object.NonBranchNodeList;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link NonBranchNodeCaseBuilder} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     NonBranchNodeCaseBuilder createTarget(int fooXyzzy, int barBaz) {
 *         return new NonBranchNodeCaseBuilderBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of NonBranchNodeCaseBuilder, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization oportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see NonBranchNodeCaseBuilder
 * @see Builder
 *
 */
@Generated("mdsal-binding-generator")
public class NonBranchNodeCaseBuilder implements Builder<NonBranchNodeCase> {

    private NonBranchNodeList _nonBranchNodeList;


    Map<Class<? extends Augmentation<NonBranchNodeCase>>, Augmentation<NonBranchNodeCase>> augmentation = Collections.emptyMap();

    public NonBranchNodeCaseBuilder() {
    }
    
    
    
    
    public NonBranchNodeCaseBuilder(NonBranchNodeObject arg) {
        this._nonBranchNodeList = arg.getNonBranchNodeList();
    }

    public NonBranchNodeCaseBuilder(NonBranchNodeCase base) {
        Map<Class<? extends Augmentation<NonBranchNodeCase>>, Augmentation<NonBranchNodeCase>> aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._nonBranchNodeList = base.getNonBranchNodeList();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>NonBranchNodeObject</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof NonBranchNodeObject) {
            this._nonBranchNodeList = ((NonBranchNodeObject)arg).getNonBranchNodeList();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[NonBranchNodeObject]");
    }

    public NonBranchNodeList getNonBranchNodeList() {
        return _nonBranchNodeList;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<NonBranchNodeCase>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    public NonBranchNodeCaseBuilder setNonBranchNodeList(final NonBranchNodeList value) {
        this._nonBranchNodeList = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public NonBranchNodeCaseBuilder addAugmentation(Augmentation<NonBranchNodeCase> augmentation) {
        Class<? extends Augmentation<NonBranchNodeCase>> augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public NonBranchNodeCaseBuilder removeAugmentation(Class<? extends Augmentation<NonBranchNodeCase>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public NonBranchNodeCase build() {
        return new NonBranchNodeCaseImpl(this);
    }

    private static final class NonBranchNodeCaseImpl
        extends AbstractAugmentable<NonBranchNodeCase>
        implements NonBranchNodeCase {
    
        private final NonBranchNodeList _nonBranchNodeList;
    
        NonBranchNodeCaseImpl(NonBranchNodeCaseBuilder base) {
            super(base.augmentation);
            this._nonBranchNodeList = base.getNonBranchNodeList();
        }
    
        @Override
        public NonBranchNodeList getNonBranchNodeList() {
            return _nonBranchNodeList;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = NonBranchNodeCase.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return NonBranchNodeCase.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return NonBranchNodeCase.bindingToString(this);
        }
    }
}
