package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.classtype.object;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Override;
import java.lang.String;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.ClasstypeObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>pcep-types</b>
 * <pre>
 * container class-type {
 *   uses object;
 *   leaf class-type {
 *     type class-type;
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>pcep-typesclasstype-objectclass-type</i>
 *
 * <p>To create instances of this class use {@link ClassTypeBuilder}.
 * @see ClassTypeBuilder
 *
 */
@Generated("mdsal-binding-generator")
public interface ClassType
    extends
    ChildOf<ClasstypeObject>,
    Augmentable<ClassType>,
    Object
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("class-type");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.classtype.object.ClassType> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.classtype.object.ClassType.class;
    }
    
    /**
     * Default implementation of {@link java.lang.Object#hashCode()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent hashing
     * results across all implementations.
     *
     * @param obj Object for which to generate hashCode() result.
     * @return Hash code value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static int bindingHashCode(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.classtype.object.@NonNull ClassType obj) {
        final int prime = 31;
        int result = 1;
        result = prime * result + Objects.hashCode(obj.getClassType());
        result = prime * result + Objects.hashCode(obj.getIgnore());
        result = prime * result + Objects.hashCode(obj.getProcessingRule());
        for (var augmentation : obj.augmentations().values()) {
            result += augmentation.hashCode();
        }
        return result;
    }
    
    /**
     * Default implementation of {@link java.lang.Object#equals(java.lang.Object)} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent equality
     * results across all implementations.
     *
     * @param thisObj Object acting as the receiver of equals invocation
     * @param obj Object acting as argument to equals invocation
     * @return True if thisObj and obj are considered equal
     * @throws NullPointerException if {@code thisObj} is null
     */
    static boolean bindingEquals(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.classtype.object.@NonNull ClassType thisObj, final java.lang.Object obj) {
        if (thisObj == obj) {
            return true;
        }
        final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.classtype.object.ClassType other = CodeHelpers.checkCast(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.classtype.object.ClassType.class, obj);
        if (other == null) {
            return false;
        }
        if (!Objects.equals(thisObj.getClassType(), other.getClassType())) {
            return false;
        }
        if (!Objects.equals(thisObj.getIgnore(), other.getIgnore())) {
            return false;
        }
        if (!Objects.equals(thisObj.getProcessingRule(), other.getProcessingRule())) {
            return false;
        }
        return thisObj.augmentations().equals(other.augmentations());
    }
    
    /**
     * Default implementation of {@link java.lang.Object#toString()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent string
     * representations across all implementations.
     *
     * @param obj Object for which to generate toString() result.
     * @return {@link String} value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static String bindingToString(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.classtype.object.@NonNull ClassType obj) {
        final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("ClassType");
        CodeHelpers.appendValue(helper, "classType", obj.getClassType());
        CodeHelpers.appendValue(helper, "ignore", obj.getIgnore());
        CodeHelpers.appendValue(helper, "processingRule", obj.getProcessingRule());
        CodeHelpers.appendAugmentations(helper, "augmentation", obj);
        return helper.toString();
    }
    
    /**
     * Return classType, or {@code null} if it is not present.
     *
     * @return {@code org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.ClassType} classType, or {@code null} if it is not present.
     *
     */
    org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.ClassType getClassType();
    
    /**
     * Return classType, guaranteed to be non-null.
     *
     * @return {@code org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.ClassType} classType, guaranteed to be non-null.
     * @throws NoSuchElementException if classType is not present
     *
     */
    default org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.@NonNull ClassType requireClassType() {
        return CodeHelpers.require(getClassType(), "classtype");
    }

}

