package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.close.message;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.CloseObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.MessageHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.ProtocolVersion;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.close.object.CClose;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link CCloseMessageBuilder} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     CCloseMessageBuilder createTarget(int fooXyzzy, int barBaz) {
 *         return new CCloseMessageBuilderBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of CCloseMessageBuilder, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization oportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see CCloseMessageBuilder
 * @see Builder
 *
 */
@Generated("mdsal-binding-generator")
public class CCloseMessageBuilder implements Builder<CCloseMessage> {

    private CClose _cClose;
    private ProtocolVersion _version;


    Map<Class<? extends Augmentation<CCloseMessage>>, Augmentation<CCloseMessage>> augmentation = Collections.emptyMap();

    public CCloseMessageBuilder() {
    }
    
    
    
    public CCloseMessageBuilder(MessageHeader arg) {
        this._version = arg.getVersion();
    }
    
    public CCloseMessageBuilder(CloseObject arg) {
        this._cClose = arg.getCClose();
    }

    public CCloseMessageBuilder(CCloseMessage base) {
        Map<Class<? extends Augmentation<CCloseMessage>>, Augmentation<CCloseMessage>> aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._cClose = base.getCClose();
        this._version = base.getVersion();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>MessageHeader</li>
     * <li>CloseObject</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof MessageHeader) {
            this._version = ((MessageHeader)arg).getVersion();
            isValidArg = true;
        }
        if (arg instanceof CloseObject) {
            this._cClose = ((CloseObject)arg).getCClose();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[MessageHeader, CloseObject]");
    }

    public CClose getCClose() {
        return _cClose;
    }
    
    public ProtocolVersion getVersion() {
        return _version;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<CCloseMessage>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    public CCloseMessageBuilder setCClose(final CClose value) {
        this._cClose = value;
        return this;
    }
    
    public CCloseMessageBuilder setVersion(final ProtocolVersion value) {
        this._version = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public CCloseMessageBuilder addAugmentation(Augmentation<CCloseMessage> augmentation) {
        Class<? extends Augmentation<CCloseMessage>> augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public CCloseMessageBuilder removeAugmentation(Class<? extends Augmentation<CCloseMessage>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public CCloseMessage build() {
        return new CCloseMessageImpl(this);
    }

    private static final class CCloseMessageImpl
        extends AbstractAugmentable<CCloseMessage>
        implements CCloseMessage {
    
        private final CClose _cClose;
        private final ProtocolVersion _version;
    
        CCloseMessageImpl(CCloseMessageBuilder base) {
            super(base.augmentation);
            this._cClose = base.getCClose();
            this._version = base.getVersion();
        }
    
        @Override
        public CClose getCClose() {
            return _cClose;
        }
        
        @Override
        public ProtocolVersion getVersion() {
            return _version;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = CCloseMessage.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return CCloseMessage.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return CCloseMessage.bindingToString(this);
        }
    }
}
