package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.endpoints.address.family;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.endpoints.address.family.p2mp.ipv4._case.P2mpIpv4;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;

/**
 * Class that builds {@link P2mpIpv4CaseBuilder} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     P2mpIpv4CaseBuilder createTarget(int fooXyzzy, int barBaz) {
 *         return new P2mpIpv4CaseBuilderBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of P2mpIpv4CaseBuilder, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization oportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see P2mpIpv4CaseBuilder
 * @see Builder
 *
 */
@Generated("mdsal-binding-generator")
public class P2mpIpv4CaseBuilder implements Builder<P2mpIpv4Case> {

    private P2mpIpv4 _p2mpIpv4;


    Map<Class<? extends Augmentation<P2mpIpv4Case>>, Augmentation<P2mpIpv4Case>> augmentation = Collections.emptyMap();

    public P2mpIpv4CaseBuilder() {
    }
    
    
    

    public P2mpIpv4CaseBuilder(P2mpIpv4Case base) {
        Map<Class<? extends Augmentation<P2mpIpv4Case>>, Augmentation<P2mpIpv4Case>> aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._p2mpIpv4 = base.getP2mpIpv4();
    }


    public P2mpIpv4 getP2mpIpv4() {
        return _p2mpIpv4;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<P2mpIpv4Case>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    public P2mpIpv4CaseBuilder setP2mpIpv4(final P2mpIpv4 value) {
        this._p2mpIpv4 = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public P2mpIpv4CaseBuilder addAugmentation(Augmentation<P2mpIpv4Case> augmentation) {
        Class<? extends Augmentation<P2mpIpv4Case>> augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public P2mpIpv4CaseBuilder removeAugmentation(Class<? extends Augmentation<P2mpIpv4Case>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public P2mpIpv4Case build() {
        return new P2mpIpv4CaseImpl(this);
    }

    private static final class P2mpIpv4CaseImpl
        extends AbstractAugmentable<P2mpIpv4Case>
        implements P2mpIpv4Case {
    
        private final P2mpIpv4 _p2mpIpv4;
    
        P2mpIpv4CaseImpl(P2mpIpv4CaseBuilder base) {
            super(base.augmentation);
            this._p2mpIpv4 = base.getP2mpIpv4();
        }
    
        @Override
        public P2mpIpv4 getP2mpIpv4() {
            return _p2mpIpv4;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = P2mpIpv4Case.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return P2mpIpv4Case.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return P2mpIpv4Case.bindingToString(this);
        }
    }
}
