package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.endpoints.address.family.ipv4._case;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv4AddressNoZone;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.EndpointsIpv4Source;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link Ipv4Builder} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     Ipv4Builder createTarget(int fooXyzzy, int barBaz) {
 *         return new Ipv4BuilderBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of Ipv4Builder, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization oportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see Ipv4Builder
 * @see Builder
 *
 */
@Generated("mdsal-binding-generator")
public class Ipv4Builder implements Builder<Ipv4> {

    private Ipv4AddressNoZone _destinationIpv4Address;
    private Ipv4AddressNoZone _sourceIpv4Address;


    Map<Class<? extends Augmentation<Ipv4>>, Augmentation<Ipv4>> augmentation = Collections.emptyMap();

    public Ipv4Builder() {
    }
    
    
    
    public Ipv4Builder(EndpointsIpv4Source arg) {
        this._sourceIpv4Address = arg.getSourceIpv4Address();
    }

    public Ipv4Builder(Ipv4 base) {
        Map<Class<? extends Augmentation<Ipv4>>, Augmentation<Ipv4>> aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._destinationIpv4Address = base.getDestinationIpv4Address();
        this._sourceIpv4Address = base.getSourceIpv4Address();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>EndpointsIpv4Source</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof EndpointsIpv4Source) {
            this._sourceIpv4Address = ((EndpointsIpv4Source)arg).getSourceIpv4Address();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[EndpointsIpv4Source]");
    }

    public Ipv4AddressNoZone getDestinationIpv4Address() {
        return _destinationIpv4Address;
    }
    
    public Ipv4AddressNoZone getSourceIpv4Address() {
        return _sourceIpv4Address;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<Ipv4>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    public Ipv4Builder setDestinationIpv4Address(final Ipv4AddressNoZone value) {
        this._destinationIpv4Address = value;
        return this;
    }
    
    public Ipv4Builder setSourceIpv4Address(final Ipv4AddressNoZone value) {
        this._sourceIpv4Address = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public Ipv4Builder addAugmentation(Augmentation<Ipv4> augmentation) {
        Class<? extends Augmentation<Ipv4>> augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public Ipv4Builder removeAugmentation(Class<? extends Augmentation<Ipv4>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public Ipv4 build() {
        return new Ipv4Impl(this);
    }

    private static final class Ipv4Impl
        extends AbstractAugmentable<Ipv4>
        implements Ipv4 {
    
        private final Ipv4AddressNoZone _destinationIpv4Address;
        private final Ipv4AddressNoZone _sourceIpv4Address;
    
        Ipv4Impl(Ipv4Builder base) {
            super(base.augmentation);
            this._destinationIpv4Address = base.getDestinationIpv4Address();
            this._sourceIpv4Address = base.getSourceIpv4Address();
        }
    
        @Override
        public Ipv4AddressNoZone getDestinationIpv4Address() {
            return _destinationIpv4Address;
        }
        
        @Override
        public Ipv4AddressNoZone getSourceIpv4Address() {
            return _sourceIpv4Address;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = Ipv4.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return Ipv4.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return Ipv4.bindingToString(this);
        }
    }
}
