package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.endpoints.address.family.ipv6._case;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv6AddressNoZone;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Endpoints;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.EndpointsIpv6Source;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>pcep-types</b>
 * <pre>
 * container ipv6 {
 *   uses endpoints-ipv6-source;
 *   leaf destination-ipv6-address {
 *     type inet:ipv6-address-no-zone;
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>pcep-typesendpointsaddress-familyipv6-caseipv6</i>
 *
 * <p>To create instances of this class use {@link Ipv6Builder}.
 * @see Ipv6Builder
 *
 */
@Generated("mdsal-binding-generator")
public interface Ipv6
    extends
    ChildOf<Endpoints>,
    Augmentable<Ipv6>,
    EndpointsIpv6Source
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("ipv6");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.endpoints.address.family.ipv6._case.Ipv6> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.endpoints.address.family.ipv6._case.Ipv6.class;
    }
    
    /**
     * Default implementation of {@link Object#hashCode()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent hashing
     * results across all implementations.
     *
     * @param obj Object for which to generate hashCode() result.
     * @return Hash code value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static int bindingHashCode(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.endpoints.address.family.ipv6._case.@NonNull Ipv6 obj) {
        final int prime = 31;
        int result = 1;
        result = prime * result + Objects.hashCode(obj.getDestinationIpv6Address());
        result = prime * result + Objects.hashCode(obj.getSourceIpv6Address());
        for (var augmentation : obj.augmentations().values()) {
            result += augmentation.hashCode();
        }
        return result;
    }
    
    /**
     * Default implementation of {@link Object#equals(Object)} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent equality
     * results across all implementations.
     *
     * @param thisObj Object acting as the receiver of equals invocation
     * @param obj Object acting as argument to equals invocation
     * @return True if thisObj and obj are considered equal
     * @throws NullPointerException if {@code thisObj} is null
     */
    static boolean bindingEquals(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.endpoints.address.family.ipv6._case.@NonNull Ipv6 thisObj, final Object obj) {
        if (thisObj == obj) {
            return true;
        }
        final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.endpoints.address.family.ipv6._case.Ipv6 other = CodeHelpers.checkCast(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.endpoints.address.family.ipv6._case.Ipv6.class, obj);
        if (other == null) {
            return false;
        }
        if (!Objects.equals(thisObj.getDestinationIpv6Address(), other.getDestinationIpv6Address())) {
            return false;
        }
        if (!Objects.equals(thisObj.getSourceIpv6Address(), other.getSourceIpv6Address())) {
            return false;
        }
        return thisObj.augmentations().equals(other.augmentations());
    }
    
    /**
     * Default implementation of {@link Object#toString()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent string
     * representations across all implementations.
     *
     * @param obj Object for which to generate toString() result.
     * @return {@link String} value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static String bindingToString(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.endpoints.address.family.ipv6._case.@NonNull Ipv6 obj) {
        final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("Ipv6");
        CodeHelpers.appendValue(helper, "destinationIpv6Address", obj.getDestinationIpv6Address());
        CodeHelpers.appendValue(helper, "sourceIpv6Address", obj.getSourceIpv6Address());
        CodeHelpers.appendAugmentations(helper, "augmentation", obj);
        return helper.toString();
    }
    
    /**
     * Return destinationIpv6Address, or {@code null} if it is not present.
     *
     * @return {@code Ipv6AddressNoZone} destinationIpv6Address, or {@code null} if it is not present.
     *
     */
    Ipv6AddressNoZone getDestinationIpv6Address();
    
    /**
     * Return destinationIpv6Address, guaranteed to be non-null.
     *
     * @return {@code Ipv6AddressNoZone} destinationIpv6Address, guaranteed to be non-null.
     * @throws NoSuchElementException if destinationIpv6Address is not present
     *
     */
    default @NonNull Ipv6AddressNoZone requireDestinationIpv6Address() {
        return CodeHelpers.require(getDestinationIpv6Address(), "destinationipv6address");
    }

}

