package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.endpoints.address.family.ipv6._case;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv6AddressNoZone;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.EndpointsIpv6Source;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link Ipv6Builder} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     Ipv6Builder createTarget(int fooXyzzy, int barBaz) {
 *         return new Ipv6BuilderBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of Ipv6Builder, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization oportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see Ipv6Builder
 * @see Builder
 *
 */
@Generated("mdsal-binding-generator")
public class Ipv6Builder implements Builder<Ipv6> {

    private Ipv6AddressNoZone _destinationIpv6Address;
    private Ipv6AddressNoZone _sourceIpv6Address;


    Map<Class<? extends Augmentation<Ipv6>>, Augmentation<Ipv6>> augmentation = Collections.emptyMap();

    public Ipv6Builder() {
    }
    
    
    
    public Ipv6Builder(EndpointsIpv6Source arg) {
        this._sourceIpv6Address = arg.getSourceIpv6Address();
    }

    public Ipv6Builder(Ipv6 base) {
        Map<Class<? extends Augmentation<Ipv6>>, Augmentation<Ipv6>> aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._destinationIpv6Address = base.getDestinationIpv6Address();
        this._sourceIpv6Address = base.getSourceIpv6Address();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>EndpointsIpv6Source</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof EndpointsIpv6Source) {
            this._sourceIpv6Address = ((EndpointsIpv6Source)arg).getSourceIpv6Address();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[EndpointsIpv6Source]");
    }

    public Ipv6AddressNoZone getDestinationIpv6Address() {
        return _destinationIpv6Address;
    }
    
    public Ipv6AddressNoZone getSourceIpv6Address() {
        return _sourceIpv6Address;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<Ipv6>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    public Ipv6Builder setDestinationIpv6Address(final Ipv6AddressNoZone value) {
        this._destinationIpv6Address = value;
        return this;
    }
    
    public Ipv6Builder setSourceIpv6Address(final Ipv6AddressNoZone value) {
        this._sourceIpv6Address = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public Ipv6Builder addAugmentation(Augmentation<Ipv6> augmentation) {
        Class<? extends Augmentation<Ipv6>> augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public Ipv6Builder removeAugmentation(Class<? extends Augmentation<Ipv6>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public Ipv6 build() {
        return new Ipv6Impl(this);
    }

    private static final class Ipv6Impl
        extends AbstractAugmentable<Ipv6>
        implements Ipv6 {
    
        private final Ipv6AddressNoZone _destinationIpv6Address;
        private final Ipv6AddressNoZone _sourceIpv6Address;
    
        Ipv6Impl(Ipv6Builder base) {
            super(base.augmentation);
            this._destinationIpv6Address = base.getDestinationIpv6Address();
            this._sourceIpv6Address = base.getSourceIpv6Address();
        }
    
        @Override
        public Ipv6AddressNoZone getDestinationIpv6Address() {
            return _destinationIpv6Address;
        }
        
        @Override
        public Ipv6AddressNoZone getSourceIpv6Address() {
            return _sourceIpv6Address;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = Ipv6.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return Ipv6.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return Ipv6.bindingToString(this);
        }
    }
}
