package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.endpoints.address.family.p2mp.ipv4._case;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv4AddressNoZone;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.EndpointsIpv4Source;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Ipv4Destinations;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.P2mpLeaves;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.P2mpLeavesLeaf;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link P2mpIpv4Builder} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     P2mpIpv4Builder createTarget(int fooXyzzy, int barBaz) {
 *         return new P2mpIpv4BuilderBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of P2mpIpv4Builder, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization oportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see P2mpIpv4Builder
 * @see Builder
 *
 */
@Generated("mdsal-binding-generator")
public class P2mpIpv4Builder implements Builder<P2mpIpv4> {

    private List<Ipv4AddressNoZone> _destinationIpv4Address;
    private P2mpLeaves _p2mpLeaves;
    private Ipv4AddressNoZone _sourceIpv4Address;


    Map<Class<? extends Augmentation<P2mpIpv4>>, Augmentation<P2mpIpv4>> augmentation = Collections.emptyMap();

    public P2mpIpv4Builder() {
    }
    
    
    
    public P2mpIpv4Builder(P2mpLeavesLeaf arg) {
        this._p2mpLeaves = arg.getP2mpLeaves();
    }
    
    public P2mpIpv4Builder(EndpointsIpv4Source arg) {
        this._sourceIpv4Address = arg.getSourceIpv4Address();
    }
    
    public P2mpIpv4Builder(Ipv4Destinations arg) {
        this._destinationIpv4Address = arg.getDestinationIpv4Address();
    }

    public P2mpIpv4Builder(P2mpIpv4 base) {
        Map<Class<? extends Augmentation<P2mpIpv4>>, Augmentation<P2mpIpv4>> aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._destinationIpv4Address = base.getDestinationIpv4Address();
        this._p2mpLeaves = base.getP2mpLeaves();
        this._sourceIpv4Address = base.getSourceIpv4Address();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>Ipv4Destinations</li>
     * <li>P2mpLeavesLeaf</li>
     * <li>EndpointsIpv4Source</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof Ipv4Destinations) {
            this._destinationIpv4Address = ((Ipv4Destinations)arg).getDestinationIpv4Address();
            isValidArg = true;
        }
        if (arg instanceof P2mpLeavesLeaf) {
            this._p2mpLeaves = ((P2mpLeavesLeaf)arg).getP2mpLeaves();
            isValidArg = true;
        }
        if (arg instanceof EndpointsIpv4Source) {
            this._sourceIpv4Address = ((EndpointsIpv4Source)arg).getSourceIpv4Address();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[Ipv4Destinations, P2mpLeavesLeaf, EndpointsIpv4Source]");
    }

    public List<Ipv4AddressNoZone> getDestinationIpv4Address() {
        return _destinationIpv4Address;
    }
    
    public P2mpLeaves getP2mpLeaves() {
        return _p2mpLeaves;
    }
    
    public Ipv4AddressNoZone getSourceIpv4Address() {
        return _sourceIpv4Address;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<P2mpIpv4>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public P2mpIpv4Builder setDestinationIpv4Address(final List<Ipv4AddressNoZone> values) {
        this._destinationIpv4Address = values;
        return this;
    }
    
    
    public P2mpIpv4Builder setP2mpLeaves(final P2mpLeaves value) {
        this._p2mpLeaves = value;
        return this;
    }
    
    public P2mpIpv4Builder setSourceIpv4Address(final Ipv4AddressNoZone value) {
        this._sourceIpv4Address = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public P2mpIpv4Builder addAugmentation(Augmentation<P2mpIpv4> augmentation) {
        Class<? extends Augmentation<P2mpIpv4>> augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public P2mpIpv4Builder removeAugmentation(Class<? extends Augmentation<P2mpIpv4>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public P2mpIpv4 build() {
        return new P2mpIpv4Impl(this);
    }

    private static final class P2mpIpv4Impl
        extends AbstractAugmentable<P2mpIpv4>
        implements P2mpIpv4 {
    
        private final List<Ipv4AddressNoZone> _destinationIpv4Address;
        private final P2mpLeaves _p2mpLeaves;
        private final Ipv4AddressNoZone _sourceIpv4Address;
    
        P2mpIpv4Impl(P2mpIpv4Builder base) {
            super(base.augmentation);
            this._destinationIpv4Address = base.getDestinationIpv4Address();
            this._p2mpLeaves = base.getP2mpLeaves();
            this._sourceIpv4Address = base.getSourceIpv4Address();
        }
    
        @Override
        public List<Ipv4AddressNoZone> getDestinationIpv4Address() {
            return _destinationIpv4Address;
        }
        
        @Override
        public P2mpLeaves getP2mpLeaves() {
            return _p2mpLeaves;
        }
        
        @Override
        public Ipv4AddressNoZone getSourceIpv4Address() {
            return _sourceIpv4Address;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = P2mpIpv4.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return P2mpIpv4.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return P2mpIpv4.bindingToString(this);
        }
    }
}
