package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.endpoints.address.family.p2mp.ipv6._case;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv6AddressNoZone;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.EndpointsIpv6Source;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Ipv6Destinations;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.P2mpLeaves;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.P2mpLeavesLeaf;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link P2mpIpv6Builder} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     P2mpIpv6Builder createTarget(int fooXyzzy, int barBaz) {
 *         return new P2mpIpv6BuilderBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of P2mpIpv6Builder, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization oportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see P2mpIpv6Builder
 * @see Builder
 *
 */
@Generated("mdsal-binding-generator")
public class P2mpIpv6Builder implements Builder<P2mpIpv6> {

    private List<Ipv6AddressNoZone> _destinationIpv6Address;
    private P2mpLeaves _p2mpLeaves;
    private Ipv6AddressNoZone _sourceIpv6Address;


    Map<Class<? extends Augmentation<P2mpIpv6>>, Augmentation<P2mpIpv6>> augmentation = Collections.emptyMap();

    public P2mpIpv6Builder() {
    }
    
    
    
    public P2mpIpv6Builder(P2mpLeavesLeaf arg) {
        this._p2mpLeaves = arg.getP2mpLeaves();
    }
    
    public P2mpIpv6Builder(EndpointsIpv6Source arg) {
        this._sourceIpv6Address = arg.getSourceIpv6Address();
    }
    
    public P2mpIpv6Builder(Ipv6Destinations arg) {
        this._destinationIpv6Address = arg.getDestinationIpv6Address();
    }

    public P2mpIpv6Builder(P2mpIpv6 base) {
        Map<Class<? extends Augmentation<P2mpIpv6>>, Augmentation<P2mpIpv6>> aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._destinationIpv6Address = base.getDestinationIpv6Address();
        this._p2mpLeaves = base.getP2mpLeaves();
        this._sourceIpv6Address = base.getSourceIpv6Address();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>EndpointsIpv6Source</li>
     * <li>P2mpLeavesLeaf</li>
     * <li>Ipv6Destinations</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof EndpointsIpv6Source) {
            this._sourceIpv6Address = ((EndpointsIpv6Source)arg).getSourceIpv6Address();
            isValidArg = true;
        }
        if (arg instanceof P2mpLeavesLeaf) {
            this._p2mpLeaves = ((P2mpLeavesLeaf)arg).getP2mpLeaves();
            isValidArg = true;
        }
        if (arg instanceof Ipv6Destinations) {
            this._destinationIpv6Address = ((Ipv6Destinations)arg).getDestinationIpv6Address();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[EndpointsIpv6Source, P2mpLeavesLeaf, Ipv6Destinations]");
    }

    public List<Ipv6AddressNoZone> getDestinationIpv6Address() {
        return _destinationIpv6Address;
    }
    
    public P2mpLeaves getP2mpLeaves() {
        return _p2mpLeaves;
    }
    
    public Ipv6AddressNoZone getSourceIpv6Address() {
        return _sourceIpv6Address;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<P2mpIpv6>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public P2mpIpv6Builder setDestinationIpv6Address(final List<Ipv6AddressNoZone> values) {
        this._destinationIpv6Address = values;
        return this;
    }
    
    
    public P2mpIpv6Builder setP2mpLeaves(final P2mpLeaves value) {
        this._p2mpLeaves = value;
        return this;
    }
    
    public P2mpIpv6Builder setSourceIpv6Address(final Ipv6AddressNoZone value) {
        this._sourceIpv6Address = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public P2mpIpv6Builder addAugmentation(Augmentation<P2mpIpv6> augmentation) {
        Class<? extends Augmentation<P2mpIpv6>> augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public P2mpIpv6Builder removeAugmentation(Class<? extends Augmentation<P2mpIpv6>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public P2mpIpv6 build() {
        return new P2mpIpv6Impl(this);
    }

    private static final class P2mpIpv6Impl
        extends AbstractAugmentable<P2mpIpv6>
        implements P2mpIpv6 {
    
        private final List<Ipv6AddressNoZone> _destinationIpv6Address;
        private final P2mpLeaves _p2mpLeaves;
        private final Ipv6AddressNoZone _sourceIpv6Address;
    
        P2mpIpv6Impl(P2mpIpv6Builder base) {
            super(base.augmentation);
            this._destinationIpv6Address = base.getDestinationIpv6Address();
            this._p2mpLeaves = base.getP2mpLeaves();
            this._sourceIpv6Address = base.getSourceIpv6Address();
        }
    
        @Override
        public List<Ipv6AddressNoZone> getDestinationIpv6Address() {
            return _destinationIpv6Address;
        }
        
        @Override
        public P2mpLeaves getP2mpLeaves() {
            return _p2mpLeaves;
        }
        
        @Override
        public Ipv6AddressNoZone getSourceIpv6Address() {
            return _sourceIpv6Address;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = P2mpIpv6.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return P2mpIpv6.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return P2mpIpv6.bindingToString(this);
        }
    }
}
