package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.gc.object;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Override;
import java.lang.String;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.GcObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.gc.object.gc.Tlvs;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.Uint8;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>pcep-types</b>
 * <pre>
 * container gc {
 *   uses object;
 *   leaf max-hop {
 *     type uint8;
 *   }
 *   leaf max-utilization {
 *     type uint8 {
 *       range 0..100;
 *     }
 *     units percent;
 *   }
 *   leaf min-utilization {
 *     type uint8 {
 *       range 0..100;
 *     }
 *     units percent;
 *   }
 *   leaf over-booking-factor {
 *     type uint8 {
 *       range 0..100;
 *     }
 *     units percent;
 *   }
 *   container tlvs {
 *     uses vendor-information-tlvs;
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>pcep-typesgc-objectgc</i>
 *
 * <p>To create instances of this class use {@link GcBuilder}.
 * @see GcBuilder
 *
 */
@Generated("mdsal-binding-generator")
public interface Gc
    extends
    ChildOf<GcObject>,
    Augmentable<Gc>,
    Object
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("gc");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.gc.object.Gc> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.gc.object.Gc.class;
    }
    
    /**
     * Default implementation of {@link java.lang.Object#hashCode()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent hashing
     * results across all implementations.
     *
     * @param obj Object for which to generate hashCode() result.
     * @return Hash code value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static int bindingHashCode(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.gc.object.@NonNull Gc obj) {
        final int prime = 31;
        int result = 1;
        result = prime * result + Objects.hashCode(obj.getIgnore());
        result = prime * result + Objects.hashCode(obj.getMaxHop());
        result = prime * result + Objects.hashCode(obj.getMaxUtilization());
        result = prime * result + Objects.hashCode(obj.getMinUtilization());
        result = prime * result + Objects.hashCode(obj.getOverBookingFactor());
        result = prime * result + Objects.hashCode(obj.getProcessingRule());
        result = prime * result + Objects.hashCode(obj.getTlvs());
        for (var augmentation : obj.augmentations().values()) {
            result += augmentation.hashCode();
        }
        return result;
    }
    
    /**
     * Default implementation of {@link java.lang.Object#equals(java.lang.Object)} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent equality
     * results across all implementations.
     *
     * @param thisObj Object acting as the receiver of equals invocation
     * @param obj Object acting as argument to equals invocation
     * @return True if thisObj and obj are considered equal
     * @throws NullPointerException if {@code thisObj} is null
     */
    static boolean bindingEquals(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.gc.object.@NonNull Gc thisObj, final java.lang.Object obj) {
        if (thisObj == obj) {
            return true;
        }
        final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.gc.object.Gc other = CodeHelpers.checkCast(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.gc.object.Gc.class, obj);
        if (other == null) {
            return false;
        }
        if (!Objects.equals(thisObj.getIgnore(), other.getIgnore())) {
            return false;
        }
        if (!Objects.equals(thisObj.getMaxHop(), other.getMaxHop())) {
            return false;
        }
        if (!Objects.equals(thisObj.getMaxUtilization(), other.getMaxUtilization())) {
            return false;
        }
        if (!Objects.equals(thisObj.getMinUtilization(), other.getMinUtilization())) {
            return false;
        }
        if (!Objects.equals(thisObj.getOverBookingFactor(), other.getOverBookingFactor())) {
            return false;
        }
        if (!Objects.equals(thisObj.getProcessingRule(), other.getProcessingRule())) {
            return false;
        }
        if (!Objects.equals(thisObj.getTlvs(), other.getTlvs())) {
            return false;
        }
        return thisObj.augmentations().equals(other.augmentations());
    }
    
    /**
     * Default implementation of {@link java.lang.Object#toString()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent string
     * representations across all implementations.
     *
     * @param obj Object for which to generate toString() result.
     * @return {@link String} value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static String bindingToString(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.gc.object.@NonNull Gc obj) {
        final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("Gc");
        CodeHelpers.appendValue(helper, "ignore", obj.getIgnore());
        CodeHelpers.appendValue(helper, "maxHop", obj.getMaxHop());
        CodeHelpers.appendValue(helper, "maxUtilization", obj.getMaxUtilization());
        CodeHelpers.appendValue(helper, "minUtilization", obj.getMinUtilization());
        CodeHelpers.appendValue(helper, "overBookingFactor", obj.getOverBookingFactor());
        CodeHelpers.appendValue(helper, "processingRule", obj.getProcessingRule());
        CodeHelpers.appendValue(helper, "tlvs", obj.getTlvs());
        CodeHelpers.appendAugmentations(helper, "augmentation", obj);
        return helper.toString();
    }
    
    /**
     * Return maxHop, or {@code null} if it is not present.
     *
     * @return {@code Uint8} maxHop, or {@code null} if it is not present.
     *
     */
    Uint8 getMaxHop();
    
    /**
     * Return maxHop, guaranteed to be non-null.
     *
     * @return {@code Uint8} maxHop, guaranteed to be non-null.
     * @throws NoSuchElementException if maxHop is not present
     *
     */
    default @NonNull Uint8 requireMaxHop() {
        return CodeHelpers.require(getMaxHop(), "maxhop");
    }
    
    /**
     * Return maxUtilization, or {@code null} if it is not present.
     *
     * @return {@code Uint8} maxUtilization, or {@code null} if it is not present.
     *
     */
    Uint8 getMaxUtilization();
    
    /**
     * Return maxUtilization, guaranteed to be non-null.
     *
     * @return {@code Uint8} maxUtilization, guaranteed to be non-null.
     * @throws NoSuchElementException if maxUtilization is not present
     *
     */
    default @NonNull Uint8 requireMaxUtilization() {
        return CodeHelpers.require(getMaxUtilization(), "maxutilization");
    }
    
    /**
     * Return minUtilization, or {@code null} if it is not present.
     *
     * @return {@code Uint8} minUtilization, or {@code null} if it is not present.
     *
     */
    Uint8 getMinUtilization();
    
    /**
     * Return minUtilization, guaranteed to be non-null.
     *
     * @return {@code Uint8} minUtilization, guaranteed to be non-null.
     * @throws NoSuchElementException if minUtilization is not present
     *
     */
    default @NonNull Uint8 requireMinUtilization() {
        return CodeHelpers.require(getMinUtilization(), "minutilization");
    }
    
    /**
     * Return overBookingFactor, or {@code null} if it is not present.
     *
     * @return {@code Uint8} overBookingFactor, or {@code null} if it is not present.
     *
     */
    Uint8 getOverBookingFactor();
    
    /**
     * Return overBookingFactor, guaranteed to be non-null.
     *
     * @return {@code Uint8} overBookingFactor, guaranteed to be non-null.
     * @throws NoSuchElementException if overBookingFactor is not present
     *
     */
    default @NonNull Uint8 requireOverBookingFactor() {
        return CodeHelpers.require(getOverBookingFactor(), "overbookingfactor");
    }
    
    /**
     * Return tlvs, or {@code null} if it is not present.
     *
     * @return {@code Tlvs} tlvs, or {@code null} if it is not present.
     *
     */
    Tlvs getTlvs();

}

