package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.gc.object;
import java.lang.Boolean;
import java.lang.Class;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.ObjectHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.gc.object.gc.Tlvs;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.Uint8;

/**
 * Class that builds {@link GcBuilder} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     GcBuilder createTarget(int fooXyzzy, int barBaz) {
 *         return new GcBuilderBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of GcBuilder, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization oportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see GcBuilder
 * @see Builder
 *
 */
@Generated("mdsal-binding-generator")
public class GcBuilder implements Builder<Gc> {

    private Boolean _ignore;
    private Uint8 _maxHop;
    private Uint8 _maxUtilization;
    private Uint8 _minUtilization;
    private Uint8 _overBookingFactor;
    private Boolean _processingRule;
    private Tlvs _tlvs;


    Map<Class<? extends Augmentation<Gc>>, Augmentation<Gc>> augmentation = Collections.emptyMap();

    public GcBuilder() {
    }
    
    
    
    public GcBuilder(Object arg) {
        this._processingRule = arg.getProcessingRule();
        this._ignore = arg.getIgnore();
    }
    public GcBuilder(ObjectHeader arg) {
        this._processingRule = arg.getProcessingRule();
        this._ignore = arg.getIgnore();
    }

    public GcBuilder(Gc base) {
        Map<Class<? extends Augmentation<Gc>>, Augmentation<Gc>> aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._ignore = base.getIgnore();
        this._maxHop = base.getMaxHop();
        this._maxUtilization = base.getMaxUtilization();
        this._minUtilization = base.getMinUtilization();
        this._overBookingFactor = base.getOverBookingFactor();
        this._processingRule = base.getProcessingRule();
        this._tlvs = base.getTlvs();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>ObjectHeader</li>
     * <li>Object</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof ObjectHeader) {
            this._processingRule = ((ObjectHeader)arg).getProcessingRule();
            this._ignore = ((ObjectHeader)arg).getIgnore();
            isValidArg = true;
        }
        if (arg instanceof Object) {
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[ObjectHeader, Object]");
    }

    public Boolean getIgnore() {
        return _ignore;
    }
    
    public Uint8 getMaxHop() {
        return _maxHop;
    }
    
    public Uint8 getMaxUtilization() {
        return _maxUtilization;
    }
    
    public Uint8 getMinUtilization() {
        return _minUtilization;
    }
    
    public Uint8 getOverBookingFactor() {
        return _overBookingFactor;
    }
    
    public Boolean getProcessingRule() {
        return _processingRule;
    }
    
    public Tlvs getTlvs() {
        return _tlvs;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<Gc>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    public GcBuilder setIgnore(final Boolean value) {
        this._ignore = value;
        return this;
    }
    
    public GcBuilder setMaxHop(final Uint8 value) {
        this._maxHop = value;
        return this;
    }
    
    private static void checkMaxUtilizationRange(final short value) {
        if (value <= (short)100) {
            return;
        }
        CodeHelpers.throwInvalidRange("[[0..100]]", value);
    }
    
    public GcBuilder setMaxUtilization(final Uint8 value) {
        if (value != null) {
            checkMaxUtilizationRange(value.shortValue());
            
        }
        this._maxUtilization = value;
        return this;
    }
    
    private static void checkMinUtilizationRange(final short value) {
        if (value <= (short)100) {
            return;
        }
        CodeHelpers.throwInvalidRange("[[0..100]]", value);
    }
    
    public GcBuilder setMinUtilization(final Uint8 value) {
        if (value != null) {
            checkMinUtilizationRange(value.shortValue());
            
        }
        this._minUtilization = value;
        return this;
    }
    
    private static void checkOverBookingFactorRange(final short value) {
        if (value <= (short)100) {
            return;
        }
        CodeHelpers.throwInvalidRange("[[0..100]]", value);
    }
    
    public GcBuilder setOverBookingFactor(final Uint8 value) {
        if (value != null) {
            checkOverBookingFactorRange(value.shortValue());
            
        }
        this._overBookingFactor = value;
        return this;
    }
    
    public GcBuilder setProcessingRule(final Boolean value) {
        this._processingRule = value;
        return this;
    }
    
    public GcBuilder setTlvs(final Tlvs value) {
        this._tlvs = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public GcBuilder addAugmentation(Augmentation<Gc> augmentation) {
        Class<? extends Augmentation<Gc>> augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public GcBuilder removeAugmentation(Class<? extends Augmentation<Gc>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public Gc build() {
        return new GcImpl(this);
    }

    private static final class GcImpl
        extends AbstractAugmentable<Gc>
        implements Gc {
    
        private final Boolean _ignore;
        private final Uint8 _maxHop;
        private final Uint8 _maxUtilization;
        private final Uint8 _minUtilization;
        private final Uint8 _overBookingFactor;
        private final Boolean _processingRule;
        private final Tlvs _tlvs;
    
        GcImpl(GcBuilder base) {
            super(base.augmentation);
            this._ignore = base.getIgnore();
            this._maxHop = base.getMaxHop();
            this._maxUtilization = base.getMaxUtilization();
            this._minUtilization = base.getMinUtilization();
            this._overBookingFactor = base.getOverBookingFactor();
            this._processingRule = base.getProcessingRule();
            this._tlvs = base.getTlvs();
        }
    
        @Override
        public Boolean getIgnore() {
            return _ignore;
        }
        
        @Override
        public Uint8 getMaxHop() {
            return _maxHop;
        }
        
        @Override
        public Uint8 getMaxUtilization() {
            return _maxUtilization;
        }
        
        @Override
        public Uint8 getMinUtilization() {
            return _minUtilization;
        }
        
        @Override
        public Uint8 getOverBookingFactor() {
            return _overBookingFactor;
        }
        
        @Override
        public Boolean getProcessingRule() {
            return _processingRule;
        }
        
        @Override
        public Tlvs getTlvs() {
            return _tlvs;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = Gc.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(java.lang.Object obj) {
            return Gc.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return Gc.bindingToString(this);
        }
    }
}
