package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.include.route.object.iro;
import com.google.common.base.MoreObjects;
import java.lang.Boolean;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.include.route.object.Iro;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.ExplicitRouteSubobjects;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>pcep-types</b>
 * <pre>
 * list subobject {
 *   leaf loose {
 *     type boolean;
 *   }
 *   uses rsvp:explicit-route-subobjects;
 *   ordered-by user;
 * }
 * </pre>The schema path to identify an instance is
 * <i>pcep-typesinclude-route-objectirosubobject</i>
 *
 * <p>To create instances of this class use {@link SubobjectBuilder}.
 * @see SubobjectBuilder
 *
 *
 */
@Generated("mdsal-binding-generator")
public interface Subobject
    extends
    ChildOf<Iro>,
    Augmentable<Subobject>,
    ExplicitRouteSubobjects
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("subobject");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.include.route.object.iro.Subobject> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.include.route.object.iro.Subobject.class;
    }
    
    /**
     * Default implementation of {@link Object#hashCode()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent hashing
     * results across all implementations.
     *
     * @param obj Object for which to generate hashCode() result.
     * @return Hash code value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static int bindingHashCode(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.include.route.object.iro.@NonNull Subobject obj) {
        final int prime = 31;
        int result = 1;
        result = prime * result + Objects.hashCode(obj.getLoose());
        result = prime * result + Objects.hashCode(obj.getSubobjectType());
        for (var augmentation : obj.augmentations().values()) {
            result += augmentation.hashCode();
        }
        return result;
    }
    
    /**
     * Default implementation of {@link Object#equals(Object)} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent equality
     * results across all implementations.
     *
     * @param thisObj Object acting as the receiver of equals invocation
     * @param obj Object acting as argument to equals invocation
     * @return True if thisObj and obj are considered equal
     * @throws NullPointerException if {@code thisObj} is null
     */
    static boolean bindingEquals(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.include.route.object.iro.@NonNull Subobject thisObj, final Object obj) {
        if (thisObj == obj) {
            return true;
        }
        final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.include.route.object.iro.Subobject other = CodeHelpers.checkCast(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.include.route.object.iro.Subobject.class, obj);
        if (other == null) {
            return false;
        }
        if (!Objects.equals(thisObj.getLoose(), other.getLoose())) {
            return false;
        }
        if (!Objects.equals(thisObj.getSubobjectType(), other.getSubobjectType())) {
            return false;
        }
        return thisObj.augmentations().equals(other.augmentations());
    }
    
    /**
     * Default implementation of {@link Object#toString()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent string
     * representations across all implementations.
     *
     * @param obj Object for which to generate toString() result.
     * @return {@link String} value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static String bindingToString(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.include.route.object.iro.@NonNull Subobject obj) {
        final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("Subobject");
        CodeHelpers.appendValue(helper, "loose", obj.getLoose());
        CodeHelpers.appendValue(helper, "subobjectType", obj.getSubobjectType());
        CodeHelpers.appendAugmentations(helper, "augmentation", obj);
        return helper.toString();
    }
    
    /**
     * Return loose, or {@code null} if it is not present.
     *
     * @return {@code Boolean} loose, or {@code null} if it is not present.
     *
     */
    Boolean getLoose();
    
    /**
     * Return loose, guaranteed to be non-null.
     *
     * @return {@code Boolean} loose, guaranteed to be non-null.
     * @throws NoSuchElementException if loose is not present
     *
     */
    default @NonNull Boolean requireLoose() {
        return CodeHelpers.require(getLoose(), "loose");
    }

}

