package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.load.balancing.object;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Override;
import java.lang.String;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.network.concepts.rev131125.Bandwidth;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.LoadBalancingObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.Uint8;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>pcep-types</b>
 * <pre>
 * container load-balancing {
 *   uses object;
 *   leaf max-lsp {
 *     type uint8;
 *   }
 *   leaf min-bandwidth {
 *     type netc:bandwidth;
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>pcep-typesload-balancing-objectload-balancing</i>
 *
 * <p>To create instances of this class use {@link LoadBalancingBuilder}.
 * @see LoadBalancingBuilder
 *
 */
@Generated("mdsal-binding-generator")
public interface LoadBalancing
    extends
    ChildOf<LoadBalancingObject>,
    Augmentable<LoadBalancing>,
    Object
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("load-balancing");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.load.balancing.object.LoadBalancing> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.load.balancing.object.LoadBalancing.class;
    }
    
    /**
     * Default implementation of {@link java.lang.Object#hashCode()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent hashing
     * results across all implementations.
     *
     * @param obj Object for which to generate hashCode() result.
     * @return Hash code value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static int bindingHashCode(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.load.balancing.object.@NonNull LoadBalancing obj) {
        final int prime = 31;
        int result = 1;
        result = prime * result + Objects.hashCode(obj.getIgnore());
        result = prime * result + Objects.hashCode(obj.getMaxLsp());
        result = prime * result + Objects.hashCode(obj.getMinBandwidth());
        result = prime * result + Objects.hashCode(obj.getProcessingRule());
        for (var augmentation : obj.augmentations().values()) {
            result += augmentation.hashCode();
        }
        return result;
    }
    
    /**
     * Default implementation of {@link java.lang.Object#equals(java.lang.Object)} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent equality
     * results across all implementations.
     *
     * @param thisObj Object acting as the receiver of equals invocation
     * @param obj Object acting as argument to equals invocation
     * @return True if thisObj and obj are considered equal
     * @throws NullPointerException if {@code thisObj} is null
     */
    static boolean bindingEquals(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.load.balancing.object.@NonNull LoadBalancing thisObj, final java.lang.Object obj) {
        if (thisObj == obj) {
            return true;
        }
        final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.load.balancing.object.LoadBalancing other = CodeHelpers.checkCast(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.load.balancing.object.LoadBalancing.class, obj);
        if (other == null) {
            return false;
        }
        if (!Objects.equals(thisObj.getIgnore(), other.getIgnore())) {
            return false;
        }
        if (!Objects.equals(thisObj.getMaxLsp(), other.getMaxLsp())) {
            return false;
        }
        if (!Objects.equals(thisObj.getProcessingRule(), other.getProcessingRule())) {
            return false;
        }
        if (!Objects.equals(thisObj.getMinBandwidth(), other.getMinBandwidth())) {
            return false;
        }
        return thisObj.augmentations().equals(other.augmentations());
    }
    
    /**
     * Default implementation of {@link java.lang.Object#toString()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent string
     * representations across all implementations.
     *
     * @param obj Object for which to generate toString() result.
     * @return {@link String} value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static String bindingToString(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.load.balancing.object.@NonNull LoadBalancing obj) {
        final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("LoadBalancing");
        CodeHelpers.appendValue(helper, "ignore", obj.getIgnore());
        CodeHelpers.appendValue(helper, "maxLsp", obj.getMaxLsp());
        CodeHelpers.appendValue(helper, "minBandwidth", obj.getMinBandwidth());
        CodeHelpers.appendValue(helper, "processingRule", obj.getProcessingRule());
        CodeHelpers.appendAugmentations(helper, "augmentation", obj);
        return helper.toString();
    }
    
    /**
     * Return maxLsp, or {@code null} if it is not present.
     *
     * @return {@code Uint8} maxLsp, or {@code null} if it is not present.
     *
     */
    Uint8 getMaxLsp();
    
    /**
     * Return maxLsp, guaranteed to be non-null.
     *
     * @return {@code Uint8} maxLsp, guaranteed to be non-null.
     * @throws NoSuchElementException if maxLsp is not present
     *
     */
    default @NonNull Uint8 requireMaxLsp() {
        return CodeHelpers.require(getMaxLsp(), "maxlsp");
    }
    
    /**
     * Return minBandwidth, or {@code null} if it is not present.
     *
     * @return {@code Bandwidth} minBandwidth, or {@code null} if it is not present.
     *
     */
    Bandwidth getMinBandwidth();
    
    /**
     * Return minBandwidth, guaranteed to be non-null.
     *
     * @return {@code Bandwidth} minBandwidth, guaranteed to be non-null.
     * @throws NoSuchElementException if minBandwidth is not present
     *
     */
    default @NonNull Bandwidth requireMinBandwidth() {
        return CodeHelpers.require(getMinBandwidth(), "minbandwidth");
    }

}

