package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.load.balancing.object;
import java.lang.Boolean;
import java.lang.Class;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.network.concepts.rev131125.Bandwidth;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.ObjectHeader;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.Uint8;

/**
 * Class that builds {@link LoadBalancingBuilder} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     LoadBalancingBuilder createTarget(int fooXyzzy, int barBaz) {
 *         return new LoadBalancingBuilderBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of LoadBalancingBuilder, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization oportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see LoadBalancingBuilder
 * @see Builder
 *
 */
@Generated("mdsal-binding-generator")
public class LoadBalancingBuilder implements Builder<LoadBalancing> {

    private Boolean _ignore;
    private Uint8 _maxLsp;
    private Bandwidth _minBandwidth;
    private Boolean _processingRule;


    Map<Class<? extends Augmentation<LoadBalancing>>, Augmentation<LoadBalancing>> augmentation = Collections.emptyMap();

    public LoadBalancingBuilder() {
    }
    
    
    
    public LoadBalancingBuilder(Object arg) {
        this._processingRule = arg.getProcessingRule();
        this._ignore = arg.getIgnore();
    }
    public LoadBalancingBuilder(ObjectHeader arg) {
        this._processingRule = arg.getProcessingRule();
        this._ignore = arg.getIgnore();
    }

    public LoadBalancingBuilder(LoadBalancing base) {
        Map<Class<? extends Augmentation<LoadBalancing>>, Augmentation<LoadBalancing>> aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._ignore = base.getIgnore();
        this._maxLsp = base.getMaxLsp();
        this._minBandwidth = base.getMinBandwidth();
        this._processingRule = base.getProcessingRule();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>ObjectHeader</li>
     * <li>Object</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof ObjectHeader) {
            this._processingRule = ((ObjectHeader)arg).getProcessingRule();
            this._ignore = ((ObjectHeader)arg).getIgnore();
            isValidArg = true;
        }
        if (arg instanceof Object) {
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[ObjectHeader, Object]");
    }

    public Boolean getIgnore() {
        return _ignore;
    }
    
    public Uint8 getMaxLsp() {
        return _maxLsp;
    }
    
    public Bandwidth getMinBandwidth() {
        return _minBandwidth;
    }
    
    public Boolean getProcessingRule() {
        return _processingRule;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<LoadBalancing>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    public LoadBalancingBuilder setIgnore(final Boolean value) {
        this._ignore = value;
        return this;
    }
    
    public LoadBalancingBuilder setMaxLsp(final Uint8 value) {
        this._maxLsp = value;
        return this;
    }
    
    public LoadBalancingBuilder setMinBandwidth(final Bandwidth value) {
        this._minBandwidth = value;
        return this;
    }
    
    public LoadBalancingBuilder setProcessingRule(final Boolean value) {
        this._processingRule = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public LoadBalancingBuilder addAugmentation(Augmentation<LoadBalancing> augmentation) {
        Class<? extends Augmentation<LoadBalancing>> augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public LoadBalancingBuilder removeAugmentation(Class<? extends Augmentation<LoadBalancing>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public LoadBalancing build() {
        return new LoadBalancingImpl(this);
    }

    private static final class LoadBalancingImpl
        extends AbstractAugmentable<LoadBalancing>
        implements LoadBalancing {
    
        private final Boolean _ignore;
        private final Uint8 _maxLsp;
        private final Bandwidth _minBandwidth;
        private final Boolean _processingRule;
    
        LoadBalancingImpl(LoadBalancingBuilder base) {
            super(base.augmentation);
            this._ignore = base.getIgnore();
            this._maxLsp = base.getMaxLsp();
            this._minBandwidth = base.getMinBandwidth();
            this._processingRule = base.getProcessingRule();
        }
    
        @Override
        public Boolean getIgnore() {
            return _ignore;
        }
        
        @Override
        public Uint8 getMaxLsp() {
            return _maxLsp;
        }
        
        @Override
        public Bandwidth getMinBandwidth() {
            return _minBandwidth;
        }
        
        @Override
        public Boolean getProcessingRule() {
            return _processingRule;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = LoadBalancing.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(java.lang.Object obj) {
            return LoadBalancing.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return LoadBalancing.bindingToString(this);
        }
    }
}
