package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.lspa.object;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.LspaObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.lspa.object.lspa.Tlvs;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.TunnelAttributes;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>pcep-types</b>
 * <pre>
 * container lspa {
 *   uses object;
 *   uses rsvp:tunnel-attributes;
 *   container tlvs {
 *     uses vendor-information-tlvs;
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>pcep-typeslspa-objectlspa</i>
 *
 * <p>To create instances of this class use {@link LspaBuilder}.
 * @see LspaBuilder
 *
 */
@Generated("mdsal-binding-generator")
public interface Lspa
    extends
    ChildOf<LspaObject>,
    Augmentable<Lspa>,
    Object,
    TunnelAttributes
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("lspa");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.lspa.object.Lspa> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.lspa.object.Lspa.class;
    }
    
    /**
     * Default implementation of {@link java.lang.Object#hashCode()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent hashing
     * results across all implementations.
     *
     * @param obj Object for which to generate hashCode() result.
     * @return Hash code value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static int bindingHashCode(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.lspa.object.@NonNull Lspa obj) {
        final int prime = 31;
        int result = 1;
        result = prime * result + Objects.hashCode(obj.getExcludeAny());
        result = prime * result + Objects.hashCode(obj.getHoldPriority());
        result = prime * result + Objects.hashCode(obj.getIgnore());
        result = prime * result + Objects.hashCode(obj.getIncludeAll());
        result = prime * result + Objects.hashCode(obj.getIncludeAny());
        result = prime * result + Objects.hashCode(obj.getLabelRecordingDesired());
        result = prime * result + Objects.hashCode(obj.getLocalProtectionDesired());
        result = prime * result + Objects.hashCode(obj.getProcessingRule());
        result = prime * result + Objects.hashCode(obj.getSeStyleDesired());
        result = prime * result + Objects.hashCode(obj.getSessionName());
        result = prime * result + Objects.hashCode(obj.getSetupPriority());
        result = prime * result + Objects.hashCode(obj.getTlvs());
        for (var augmentation : obj.augmentations().values()) {
            result += augmentation.hashCode();
        }
        return result;
    }
    
    /**
     * Default implementation of {@link java.lang.Object#equals(java.lang.Object)} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent equality
     * results across all implementations.
     *
     * @param thisObj Object acting as the receiver of equals invocation
     * @param obj Object acting as argument to equals invocation
     * @return True if thisObj and obj are considered equal
     * @throws NullPointerException if {@code thisObj} is null
     */
    static boolean bindingEquals(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.lspa.object.@NonNull Lspa thisObj, final java.lang.Object obj) {
        if (thisObj == obj) {
            return true;
        }
        final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.lspa.object.Lspa other = CodeHelpers.checkCast(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.lspa.object.Lspa.class, obj);
        if (other == null) {
            return false;
        }
        if (!Objects.equals(thisObj.getExcludeAny(), other.getExcludeAny())) {
            return false;
        }
        if (!Objects.equals(thisObj.getHoldPriority(), other.getHoldPriority())) {
            return false;
        }
        if (!Objects.equals(thisObj.getIgnore(), other.getIgnore())) {
            return false;
        }
        if (!Objects.equals(thisObj.getIncludeAll(), other.getIncludeAll())) {
            return false;
        }
        if (!Objects.equals(thisObj.getIncludeAny(), other.getIncludeAny())) {
            return false;
        }
        if (!Objects.equals(thisObj.getLabelRecordingDesired(), other.getLabelRecordingDesired())) {
            return false;
        }
        if (!Objects.equals(thisObj.getLocalProtectionDesired(), other.getLocalProtectionDesired())) {
            return false;
        }
        if (!Objects.equals(thisObj.getProcessingRule(), other.getProcessingRule())) {
            return false;
        }
        if (!Objects.equals(thisObj.getSeStyleDesired(), other.getSeStyleDesired())) {
            return false;
        }
        if (!Objects.equals(thisObj.getSetupPriority(), other.getSetupPriority())) {
            return false;
        }
        if (!Objects.equals(thisObj.getSessionName(), other.getSessionName())) {
            return false;
        }
        if (!Objects.equals(thisObj.getTlvs(), other.getTlvs())) {
            return false;
        }
        return thisObj.augmentations().equals(other.augmentations());
    }
    
    /**
     * Default implementation of {@link java.lang.Object#toString()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent string
     * representations across all implementations.
     *
     * @param obj Object for which to generate toString() result.
     * @return {@link String} value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static String bindingToString(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.lspa.object.@NonNull Lspa obj) {
        final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("Lspa");
        CodeHelpers.appendValue(helper, "excludeAny", obj.getExcludeAny());
        CodeHelpers.appendValue(helper, "holdPriority", obj.getHoldPriority());
        CodeHelpers.appendValue(helper, "ignore", obj.getIgnore());
        CodeHelpers.appendValue(helper, "includeAll", obj.getIncludeAll());
        CodeHelpers.appendValue(helper, "includeAny", obj.getIncludeAny());
        CodeHelpers.appendValue(helper, "labelRecordingDesired", obj.getLabelRecordingDesired());
        CodeHelpers.appendValue(helper, "localProtectionDesired", obj.getLocalProtectionDesired());
        CodeHelpers.appendValue(helper, "processingRule", obj.getProcessingRule());
        CodeHelpers.appendValue(helper, "seStyleDesired", obj.getSeStyleDesired());
        CodeHelpers.appendValue(helper, "sessionName", obj.getSessionName());
        CodeHelpers.appendValue(helper, "setupPriority", obj.getSetupPriority());
        CodeHelpers.appendValue(helper, "tlvs", obj.getTlvs());
        CodeHelpers.appendAugmentations(helper, "augmentation", obj);
        return helper.toString();
    }
    
    /**
     * Return tlvs, or {@code null} if it is not present.
     *
     * @return {@code Tlvs} tlvs, or {@code null} if it is not present.
     *
     */
    Tlvs getTlvs();

}

