package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.lspa.object;
import java.lang.Boolean;
import java.lang.Class;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.ObjectHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.lspa.object.lspa.Tlvs;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.AttributeFilter;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.AttributeFilters;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.Priority;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.TunnelAttributes;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.Uint8;

/**
 * Class that builds {@link LspaBuilder} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     LspaBuilder createTarget(int fooXyzzy, int barBaz) {
 *         return new LspaBuilderBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of LspaBuilder, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization oportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see LspaBuilder
 * @see Builder
 *
 */
@Generated("mdsal-binding-generator")
public class LspaBuilder implements Builder<Lspa> {

    private AttributeFilter _excludeAny;
    private Uint8 _holdPriority;
    private Boolean _ignore;
    private AttributeFilter _includeAll;
    private AttributeFilter _includeAny;
    private Boolean _labelRecordingDesired;
    private Boolean _localProtectionDesired;
    private Boolean _processingRule;
    private Boolean _seStyleDesired;
    private String _sessionName;
    private Uint8 _setupPriority;
    private Tlvs _tlvs;


    Map<Class<? extends Augmentation<Lspa>>, Augmentation<Lspa>> augmentation = Collections.emptyMap();

    public LspaBuilder() {
    }
    
    
    
    public LspaBuilder(Object arg) {
        this._processingRule = arg.getProcessingRule();
        this._ignore = arg.getIgnore();
    }
    public LspaBuilder(ObjectHeader arg) {
        this._processingRule = arg.getProcessingRule();
        this._ignore = arg.getIgnore();
    }
    
    public LspaBuilder(TunnelAttributes arg) {
        this._localProtectionDesired = arg.getLocalProtectionDesired();
        this._labelRecordingDesired = arg.getLabelRecordingDesired();
        this._seStyleDesired = arg.getSeStyleDesired();
        this._sessionName = arg.getSessionName();
        this._holdPriority = arg.getHoldPriority();
        this._setupPriority = arg.getSetupPriority();
        this._includeAny = arg.getIncludeAny();
        this._excludeAny = arg.getExcludeAny();
        this._includeAll = arg.getIncludeAll();
    }
    public LspaBuilder(Priority arg) {
        this._holdPriority = arg.getHoldPriority();
        this._setupPriority = arg.getSetupPriority();
    }
    public LspaBuilder(AttributeFilters arg) {
        this._includeAny = arg.getIncludeAny();
        this._excludeAny = arg.getExcludeAny();
        this._includeAll = arg.getIncludeAll();
    }

    public LspaBuilder(Lspa base) {
        Map<Class<? extends Augmentation<Lspa>>, Augmentation<Lspa>> aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._excludeAny = base.getExcludeAny();
        this._holdPriority = base.getHoldPriority();
        this._ignore = base.getIgnore();
        this._includeAll = base.getIncludeAll();
        this._includeAny = base.getIncludeAny();
        this._labelRecordingDesired = base.getLabelRecordingDesired();
        this._localProtectionDesired = base.getLocalProtectionDesired();
        this._processingRule = base.getProcessingRule();
        this._seStyleDesired = base.getSeStyleDesired();
        this._sessionName = base.getSessionName();
        this._setupPriority = base.getSetupPriority();
        this._tlvs = base.getTlvs();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>ObjectHeader</li>
     * <li>Priority</li>
     * <li>AttributeFilters</li>
     * <li>TunnelAttributes</li>
     * <li>Object</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof ObjectHeader) {
            this._processingRule = ((ObjectHeader)arg).getProcessingRule();
            this._ignore = ((ObjectHeader)arg).getIgnore();
            isValidArg = true;
        }
        if (arg instanceof Priority) {
            this._holdPriority = ((Priority)arg).getHoldPriority();
            this._setupPriority = ((Priority)arg).getSetupPriority();
            isValidArg = true;
        }
        if (arg instanceof AttributeFilters) {
            this._includeAny = ((AttributeFilters)arg).getIncludeAny();
            this._excludeAny = ((AttributeFilters)arg).getExcludeAny();
            this._includeAll = ((AttributeFilters)arg).getIncludeAll();
            isValidArg = true;
        }
        if (arg instanceof TunnelAttributes) {
            this._localProtectionDesired = ((TunnelAttributes)arg).getLocalProtectionDesired();
            this._labelRecordingDesired = ((TunnelAttributes)arg).getLabelRecordingDesired();
            this._seStyleDesired = ((TunnelAttributes)arg).getSeStyleDesired();
            this._sessionName = ((TunnelAttributes)arg).getSessionName();
            isValidArg = true;
        }
        if (arg instanceof Object) {
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[ObjectHeader, Priority, AttributeFilters, TunnelAttributes, Object]");
    }

    public AttributeFilter getExcludeAny() {
        return _excludeAny;
    }
    
    public Uint8 getHoldPriority() {
        return _holdPriority;
    }
    
    public Boolean getIgnore() {
        return _ignore;
    }
    
    public AttributeFilter getIncludeAll() {
        return _includeAll;
    }
    
    public AttributeFilter getIncludeAny() {
        return _includeAny;
    }
    
    public Boolean getLabelRecordingDesired() {
        return _labelRecordingDesired;
    }
    
    public Boolean getLocalProtectionDesired() {
        return _localProtectionDesired;
    }
    
    public Boolean getProcessingRule() {
        return _processingRule;
    }
    
    public Boolean getSeStyleDesired() {
        return _seStyleDesired;
    }
    
    public String getSessionName() {
        return _sessionName;
    }
    
    public Uint8 getSetupPriority() {
        return _setupPriority;
    }
    
    public Tlvs getTlvs() {
        return _tlvs;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<Lspa>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    public LspaBuilder setExcludeAny(final AttributeFilter value) {
        this._excludeAny = value;
        return this;
    }
    
    public LspaBuilder setHoldPriority(final Uint8 value) {
        this._holdPriority = value;
        return this;
    }
    
    public LspaBuilder setIgnore(final Boolean value) {
        this._ignore = value;
        return this;
    }
    
    public LspaBuilder setIncludeAll(final AttributeFilter value) {
        this._includeAll = value;
        return this;
    }
    
    public LspaBuilder setIncludeAny(final AttributeFilter value) {
        this._includeAny = value;
        return this;
    }
    
    public LspaBuilder setLabelRecordingDesired(final Boolean value) {
        this._labelRecordingDesired = value;
        return this;
    }
    
    public LspaBuilder setLocalProtectionDesired(final Boolean value) {
        this._localProtectionDesired = value;
        return this;
    }
    
    public LspaBuilder setProcessingRule(final Boolean value) {
        this._processingRule = value;
        return this;
    }
    
    public LspaBuilder setSeStyleDesired(final Boolean value) {
        this._seStyleDesired = value;
        return this;
    }
    
    public LspaBuilder setSessionName(final String value) {
        this._sessionName = value;
        return this;
    }
    
    public LspaBuilder setSetupPriority(final Uint8 value) {
        this._setupPriority = value;
        return this;
    }
    
    public LspaBuilder setTlvs(final Tlvs value) {
        this._tlvs = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public LspaBuilder addAugmentation(Augmentation<Lspa> augmentation) {
        Class<? extends Augmentation<Lspa>> augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public LspaBuilder removeAugmentation(Class<? extends Augmentation<Lspa>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public Lspa build() {
        return new LspaImpl(this);
    }

    private static final class LspaImpl
        extends AbstractAugmentable<Lspa>
        implements Lspa {
    
        private final AttributeFilter _excludeAny;
        private final Uint8 _holdPriority;
        private final Boolean _ignore;
        private final AttributeFilter _includeAll;
        private final AttributeFilter _includeAny;
        private final Boolean _labelRecordingDesired;
        private final Boolean _localProtectionDesired;
        private final Boolean _processingRule;
        private final Boolean _seStyleDesired;
        private final String _sessionName;
        private final Uint8 _setupPriority;
        private final Tlvs _tlvs;
    
        LspaImpl(LspaBuilder base) {
            super(base.augmentation);
            this._excludeAny = base.getExcludeAny();
            this._holdPriority = base.getHoldPriority();
            this._ignore = base.getIgnore();
            this._includeAll = base.getIncludeAll();
            this._includeAny = base.getIncludeAny();
            this._labelRecordingDesired = base.getLabelRecordingDesired();
            this._localProtectionDesired = base.getLocalProtectionDesired();
            this._processingRule = base.getProcessingRule();
            this._seStyleDesired = base.getSeStyleDesired();
            this._sessionName = base.getSessionName();
            this._setupPriority = base.getSetupPriority();
            this._tlvs = base.getTlvs();
        }
    
        @Override
        public AttributeFilter getExcludeAny() {
            return _excludeAny;
        }
        
        @Override
        public Uint8 getHoldPriority() {
            return _holdPriority;
        }
        
        @Override
        public Boolean getIgnore() {
            return _ignore;
        }
        
        @Override
        public AttributeFilter getIncludeAll() {
            return _includeAll;
        }
        
        @Override
        public AttributeFilter getIncludeAny() {
            return _includeAny;
        }
        
        @Override
        public Boolean getLabelRecordingDesired() {
            return _labelRecordingDesired;
        }
        
        @Override
        public Boolean getLocalProtectionDesired() {
            return _localProtectionDesired;
        }
        
        @Override
        public Boolean getProcessingRule() {
            return _processingRule;
        }
        
        @Override
        public Boolean getSeStyleDesired() {
            return _seStyleDesired;
        }
        
        @Override
        public String getSessionName() {
            return _sessionName;
        }
        
        @Override
        public Uint8 getSetupPriority() {
            return _setupPriority;
        }
        
        @Override
        public Tlvs getTlvs() {
            return _tlvs;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = Lspa.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(java.lang.Object obj) {
            return Lspa.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return Lspa.bindingToString(this);
        }
    }
}
