package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.metric.object;
import com.google.common.base.MoreObjects;
import java.lang.Boolean;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Override;
import java.lang.String;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ieee754.rev130819.Float32;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.MetricObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.Uint8;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>pcep-types</b>
 * <pre>
 * container metric {
 *   uses object;
 *   leaf metric-type {
 *     type uint8;
 *   }
 *   leaf bound {
 *     type boolean;
 *     default false;
 *   }
 *   leaf computed {
 *     type boolean;
 *     default false;
 *   }
 *   leaf value {
 *     type ieee754:float32;
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>pcep-typesmetric-objectmetric</i>
 *
 * <p>To create instances of this class use {@link MetricBuilder}.
 * @see MetricBuilder
 *
 */
@Generated("mdsal-binding-generator")
public interface Metric
    extends
    ChildOf<MetricObject>,
    Augmentable<Metric>,
    Object
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("metric");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.metric.object.Metric> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.metric.object.Metric.class;
    }
    
    /**
     * Default implementation of {@link java.lang.Object#hashCode()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent hashing
     * results across all implementations.
     *
     * @param obj Object for which to generate hashCode() result.
     * @return Hash code value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static int bindingHashCode(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.metric.object.@NonNull Metric obj) {
        final int prime = 31;
        int result = 1;
        result = prime * result + Objects.hashCode(obj.getBound());
        result = prime * result + Objects.hashCode(obj.getComputed());
        result = prime * result + Objects.hashCode(obj.getIgnore());
        result = prime * result + Objects.hashCode(obj.getMetricType());
        result = prime * result + Objects.hashCode(obj.getProcessingRule());
        result = prime * result + Objects.hashCode(obj.getValue());
        for (var augmentation : obj.augmentations().values()) {
            result += augmentation.hashCode();
        }
        return result;
    }
    
    /**
     * Default implementation of {@link java.lang.Object#equals(java.lang.Object)} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent equality
     * results across all implementations.
     *
     * @param thisObj Object acting as the receiver of equals invocation
     * @param obj Object acting as argument to equals invocation
     * @return True if thisObj and obj are considered equal
     * @throws NullPointerException if {@code thisObj} is null
     */
    static boolean bindingEquals(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.metric.object.@NonNull Metric thisObj, final java.lang.Object obj) {
        if (thisObj == obj) {
            return true;
        }
        final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.metric.object.Metric other = CodeHelpers.checkCast(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.metric.object.Metric.class, obj);
        if (other == null) {
            return false;
        }
        if (!Objects.equals(thisObj.getBound(), other.getBound())) {
            return false;
        }
        if (!Objects.equals(thisObj.getComputed(), other.getComputed())) {
            return false;
        }
        if (!Objects.equals(thisObj.getIgnore(), other.getIgnore())) {
            return false;
        }
        if (!Objects.equals(thisObj.getMetricType(), other.getMetricType())) {
            return false;
        }
        if (!Objects.equals(thisObj.getProcessingRule(), other.getProcessingRule())) {
            return false;
        }
        if (!Objects.equals(thisObj.getValue(), other.getValue())) {
            return false;
        }
        return thisObj.augmentations().equals(other.augmentations());
    }
    
    /**
     * Default implementation of {@link java.lang.Object#toString()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent string
     * representations across all implementations.
     *
     * @param obj Object for which to generate toString() result.
     * @return {@link String} value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static String bindingToString(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.metric.object.@NonNull Metric obj) {
        final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("Metric");
        CodeHelpers.appendValue(helper, "bound", obj.getBound());
        CodeHelpers.appendValue(helper, "computed", obj.getComputed());
        CodeHelpers.appendValue(helper, "ignore", obj.getIgnore());
        CodeHelpers.appendValue(helper, "metricType", obj.getMetricType());
        CodeHelpers.appendValue(helper, "processingRule", obj.getProcessingRule());
        CodeHelpers.appendValue(helper, "value", obj.getValue());
        CodeHelpers.appendAugmentations(helper, "augmentation", obj);
        return helper.toString();
    }
    
    /**
     * Return metricType, or {@code null} if it is not present.
     *
     * @return {@code Uint8} metricType, or {@code null} if it is not present.
     *
     */
    Uint8 getMetricType();
    
    /**
     * Return metricType, guaranteed to be non-null.
     *
     * @return {@code Uint8} metricType, guaranteed to be non-null.
     * @throws NoSuchElementException if metricType is not present
     *
     */
    default @NonNull Uint8 requireMetricType() {
        return CodeHelpers.require(getMetricType(), "metrictype");
    }
    
    /**
     * Return bound, or {@code null} if it is not present.
     *
     * @return {@code Boolean} bound, or {@code null} if it is not present.
     *
     */
    Boolean getBound();
    
    /**
     * Return bound, guaranteed to be non-null.
     *
     * @return {@code Boolean} bound, guaranteed to be non-null.
     * @throws NoSuchElementException if bound is not present
     *
     */
    default @NonNull Boolean requireBound() {
        return CodeHelpers.require(getBound(), "bound");
    }
    
    /**
     * Return computed, or {@code null} if it is not present.
     *
     * @return {@code Boolean} computed, or {@code null} if it is not present.
     *
     */
    Boolean getComputed();
    
    /**
     * Return computed, guaranteed to be non-null.
     *
     * @return {@code Boolean} computed, guaranteed to be non-null.
     * @throws NoSuchElementException if computed is not present
     *
     */
    default @NonNull Boolean requireComputed() {
        return CodeHelpers.require(getComputed(), "computed");
    }
    
    /**
     * Return value, or {@code null} if it is not present.
     *
     * @return {@code Float32} value, or {@code null} if it is not present.
     *
     */
    Float32 getValue();
    
    /**
     * Return value, guaranteed to be non-null.
     *
     * @return {@code Float32} value, guaranteed to be non-null.
     * @throws NoSuchElementException if value is not present
     *
     */
    default @NonNull Float32 requireValue() {
        return CodeHelpers.require(getValue(), "value");
    }

}

