package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.monitoring.object;
import com.google.common.base.MoreObjects;
import java.io.Serializable;
import java.lang.Boolean;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Override;
import java.lang.String;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.MonitoringObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.monitoring.object.monitoring.Tlvs;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.TypeObject;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.Uint32;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>pcep-types</b>
 * <pre>
 * container monitoring {
 *   uses object;
 *   leaf flags {
 *     type bits {
 *       bit incomplete {
 *         position 19;
 *       }
 *       bit overload {
 *         position 20;
 *       }
 *       bit processing-time {
 *         position 21;
 *       }
 *       bit general {
 *         position 22;
 *       }
 *       bit liveness {
 *         position 23;
 *       }
 *     }
 *   }
 *   leaf monitoring-id {
 *     type uint32;
 *   }
 *   container tlvs {
 *     uses vendor-information-tlvs;
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>pcep-typesmonitoring-objectmonitoring</i>
 *
 * <p>To create instances of this class use {@link MonitoringBuilder}.
 * @see MonitoringBuilder
 *
 */
@Generated("mdsal-binding-generator")
public interface Monitoring
    extends
    ChildOf<MonitoringObject>,
    Augmentable<Monitoring>,
    Object
{

    public static final class Flags
     implements TypeObject, Serializable {
        private static final long serialVersionUID = -3787499348650453366L;
        private final Boolean _incomplete;
        private final Boolean _overload;
        private final Boolean _processingTime;
        private final Boolean _general;
        private final Boolean _liveness;
    
    
        public Flags(Boolean _general, Boolean _incomplete, Boolean _liveness, Boolean _overload, Boolean _processingTime) {
        
            this._incomplete = _incomplete;
            this._overload = _overload;
            this._processingTime = _processingTime;
            this._general = _general;
            this._liveness = _liveness;
        }
        
        /**
         * Creates a copy from Source Object.
         *
         * @param source Source object
         */
        public Flags(Flags source) {
            this._incomplete = source._incomplete;
            this._overload = source._overload;
            this._processingTime = source._processingTime;
            this._general = source._general;
            this._liveness = source._liveness;
        }
    
    
        public Boolean getIncomplete() {
            return _incomplete;
        }
        
        public Boolean getOverload() {
            return _overload;
        }
        
        public Boolean getProcessingTime() {
            return _processingTime;
        }
        
        public Boolean getGeneral() {
            return _general;
        }
        
        public Boolean getLiveness() {
            return _liveness;
        }
    
    
        @Override
        public int hashCode() {
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_incomplete);
            result = prime * result + Objects.hashCode(_overload);
            result = prime * result + Objects.hashCode(_processingTime);
            result = prime * result + Objects.hashCode(_general);
            result = prime * result + Objects.hashCode(_liveness);
            return result;
        }
    
        @Override
        public final boolean equals(java.lang.Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof Flags)) {
                return false;
            }
            final Flags other = (Flags) obj;
            if (!Objects.equals(_incomplete, other._incomplete)) {
                return false;
            }
            if (!Objects.equals(_overload, other._overload)) {
                return false;
            }
            if (!Objects.equals(_processingTime, other._processingTime)) {
                return false;
            }
            if (!Objects.equals(_general, other._general)) {
                return false;
            }
            if (!Objects.equals(_liveness, other._liveness)) {
                return false;
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper(Flags.class);
            CodeHelpers.appendValue(helper, "_incomplete", _incomplete);
            CodeHelpers.appendValue(helper, "_overload", _overload);
            CodeHelpers.appendValue(helper, "_processingTime", _processingTime);
            CodeHelpers.appendValue(helper, "_general", _general);
            CodeHelpers.appendValue(helper, "_liveness", _liveness);
            return helper.toString();
        }
    }
    


    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("monitoring");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.monitoring.object.Monitoring> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.monitoring.object.Monitoring.class;
    }
    
    /**
     * Default implementation of {@link java.lang.Object#hashCode()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent hashing
     * results across all implementations.
     *
     * @param obj Object for which to generate hashCode() result.
     * @return Hash code value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static int bindingHashCode(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.monitoring.object.@NonNull Monitoring obj) {
        final int prime = 31;
        int result = 1;
        result = prime * result + Objects.hashCode(obj.getFlags());
        result = prime * result + Objects.hashCode(obj.getIgnore());
        result = prime * result + Objects.hashCode(obj.getMonitoringId());
        result = prime * result + Objects.hashCode(obj.getProcessingRule());
        result = prime * result + Objects.hashCode(obj.getTlvs());
        for (var augmentation : obj.augmentations().values()) {
            result += augmentation.hashCode();
        }
        return result;
    }
    
    /**
     * Default implementation of {@link java.lang.Object#equals(java.lang.Object)} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent equality
     * results across all implementations.
     *
     * @param thisObj Object acting as the receiver of equals invocation
     * @param obj Object acting as argument to equals invocation
     * @return True if thisObj and obj are considered equal
     * @throws NullPointerException if {@code thisObj} is null
     */
    static boolean bindingEquals(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.monitoring.object.@NonNull Monitoring thisObj, final java.lang.Object obj) {
        if (thisObj == obj) {
            return true;
        }
        final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.monitoring.object.Monitoring other = CodeHelpers.checkCast(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.monitoring.object.Monitoring.class, obj);
        if (other == null) {
            return false;
        }
        if (!Objects.equals(thisObj.getIgnore(), other.getIgnore())) {
            return false;
        }
        if (!Objects.equals(thisObj.getMonitoringId(), other.getMonitoringId())) {
            return false;
        }
        if (!Objects.equals(thisObj.getProcessingRule(), other.getProcessingRule())) {
            return false;
        }
        if (!Objects.equals(thisObj.getFlags(), other.getFlags())) {
            return false;
        }
        if (!Objects.equals(thisObj.getTlvs(), other.getTlvs())) {
            return false;
        }
        return thisObj.augmentations().equals(other.augmentations());
    }
    
    /**
     * Default implementation of {@link java.lang.Object#toString()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent string
     * representations across all implementations.
     *
     * @param obj Object for which to generate toString() result.
     * @return {@link String} value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static String bindingToString(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.monitoring.object.@NonNull Monitoring obj) {
        final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("Monitoring");
        CodeHelpers.appendValue(helper, "flags", obj.getFlags());
        CodeHelpers.appendValue(helper, "ignore", obj.getIgnore());
        CodeHelpers.appendValue(helper, "monitoringId", obj.getMonitoringId());
        CodeHelpers.appendValue(helper, "processingRule", obj.getProcessingRule());
        CodeHelpers.appendValue(helper, "tlvs", obj.getTlvs());
        CodeHelpers.appendAugmentations(helper, "augmentation", obj);
        return helper.toString();
    }
    
    /**
     * Return flags, or {@code null} if it is not present.
     *
     * @return {@code Flags} flags, or {@code null} if it is not present.
     *
     */
    Flags getFlags();
    
    /**
     * Return flags, guaranteed to be non-null.
     *
     * @return {@code Flags} flags, guaranteed to be non-null.
     * @throws NoSuchElementException if flags is not present
     *
     */
    default @NonNull Flags requireFlags() {
        return CodeHelpers.require(getFlags(), "flags");
    }
    
    /**
     * Return monitoringId, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         The Monitoring-id-number combined with the PCC-REQ-ID identifying the requesting
     *         PCC uniquely identifies the monitoring request context.
     *     </code>
     * </pre>
     *
     * @return {@code Uint32} monitoringId, or {@code null} if it is not present.
     *
     */
    Uint32 getMonitoringId();
    
    /**
     * Return monitoringId, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         The Monitoring-id-number combined with the PCC-REQ-ID identifying the requesting
     *         PCC uniquely identifies the monitoring request context.
     *     </code>
     * </pre>
     *
     * @return {@code Uint32} monitoringId, guaranteed to be non-null.
     * @throws NoSuchElementException if monitoringId is not present
     *
     */
    default @NonNull Uint32 requireMonitoringId() {
        return CodeHelpers.require(getMonitoringId(), "monitoringid");
    }
    
    /**
     * Return tlvs, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Optional TLV(s).
     *     </code>
     * </pre>
     *
     * @return {@code Tlvs} tlvs, or {@code null} if it is not present.
     *
     */
    Tlvs getTlvs();

}

