package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.monitoring.object;
import java.lang.Boolean;
import java.lang.Class;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.ObjectHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.monitoring.object.monitoring.Tlvs;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.Uint32;

/**
 * Class that builds {@link MonitoringBuilder} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     MonitoringBuilder createTarget(int fooXyzzy, int barBaz) {
 *         return new MonitoringBuilderBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of MonitoringBuilder, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization oportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see MonitoringBuilder
 * @see Builder
 *
 */
@Generated("mdsal-binding-generator")
public class MonitoringBuilder implements Builder<Monitoring> {

    private Monitoring.Flags _flags;
    private Boolean _ignore;
    private Uint32 _monitoringId;
    private Boolean _processingRule;
    private Tlvs _tlvs;


    Map<Class<? extends Augmentation<Monitoring>>, Augmentation<Monitoring>> augmentation = Collections.emptyMap();

    public MonitoringBuilder() {
    }
    
    
    
    public MonitoringBuilder(Object arg) {
        this._processingRule = arg.getProcessingRule();
        this._ignore = arg.getIgnore();
    }
    public MonitoringBuilder(ObjectHeader arg) {
        this._processingRule = arg.getProcessingRule();
        this._ignore = arg.getIgnore();
    }

    public MonitoringBuilder(Monitoring base) {
        Map<Class<? extends Augmentation<Monitoring>>, Augmentation<Monitoring>> aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._flags = base.getFlags();
        this._ignore = base.getIgnore();
        this._monitoringId = base.getMonitoringId();
        this._processingRule = base.getProcessingRule();
        this._tlvs = base.getTlvs();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>ObjectHeader</li>
     * <li>Object</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof ObjectHeader) {
            this._processingRule = ((ObjectHeader)arg).getProcessingRule();
            this._ignore = ((ObjectHeader)arg).getIgnore();
            isValidArg = true;
        }
        if (arg instanceof Object) {
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[ObjectHeader, Object]");
    }

    public Monitoring.Flags getFlags() {
        return _flags;
    }
    
    public Boolean getIgnore() {
        return _ignore;
    }
    
    public Uint32 getMonitoringId() {
        return _monitoringId;
    }
    
    public Boolean getProcessingRule() {
        return _processingRule;
    }
    
    public Tlvs getTlvs() {
        return _tlvs;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<Monitoring>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    public MonitoringBuilder setFlags(final Monitoring.Flags value) {
        this._flags = value;
        return this;
    }
    
    public MonitoringBuilder setIgnore(final Boolean value) {
        this._ignore = value;
        return this;
    }
    
    public MonitoringBuilder setMonitoringId(final Uint32 value) {
        this._monitoringId = value;
        return this;
    }
    
    public MonitoringBuilder setProcessingRule(final Boolean value) {
        this._processingRule = value;
        return this;
    }
    
    public MonitoringBuilder setTlvs(final Tlvs value) {
        this._tlvs = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public MonitoringBuilder addAugmentation(Augmentation<Monitoring> augmentation) {
        Class<? extends Augmentation<Monitoring>> augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public MonitoringBuilder removeAugmentation(Class<? extends Augmentation<Monitoring>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public Monitoring build() {
        return new MonitoringImpl(this);
    }

    private static final class MonitoringImpl
        extends AbstractAugmentable<Monitoring>
        implements Monitoring {
    
        private final Monitoring.Flags _flags;
        private final Boolean _ignore;
        private final Uint32 _monitoringId;
        private final Boolean _processingRule;
        private final Tlvs _tlvs;
    
        MonitoringImpl(MonitoringBuilder base) {
            super(base.augmentation);
            this._flags = base.getFlags();
            this._ignore = base.getIgnore();
            this._monitoringId = base.getMonitoringId();
            this._processingRule = base.getProcessingRule();
            this._tlvs = base.getTlvs();
        }
    
        @Override
        public Monitoring.Flags getFlags() {
            return _flags;
        }
        
        @Override
        public Boolean getIgnore() {
            return _ignore;
        }
        
        @Override
        public Uint32 getMonitoringId() {
            return _monitoringId;
        }
        
        @Override
        public Boolean getProcessingRule() {
            return _processingRule;
        }
        
        @Override
        public Tlvs getTlvs() {
            return _tlvs;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = Monitoring.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(java.lang.Object obj) {
            return Monitoring.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return Monitoring.bindingToString(this);
        }
    }
}
