package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.monitoring.response.monitoring.metrics.list.specific.metrics.list;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.MonitoringMetrics;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.RpObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.monitoring.metrics.MetricPce;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.rp.object.Rp;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link SpecificMetricsBuilder} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     SpecificMetricsBuilder createTarget(int fooXyzzy, int barBaz) {
 *         return new SpecificMetricsBuilderBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of SpecificMetricsBuilder, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization oportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see SpecificMetricsBuilder
 * @see Builder
 *
 */
@Generated("mdsal-binding-generator")
public class SpecificMetricsBuilder implements Builder<SpecificMetrics> {

    private List<MetricPce> _metricPce;
    private Rp _rp;


    Map<Class<? extends Augmentation<SpecificMetrics>>, Augmentation<SpecificMetrics>> augmentation = Collections.emptyMap();

    public SpecificMetricsBuilder() {
    }
    
    
    
    public SpecificMetricsBuilder(RpObject arg) {
        this._rp = arg.getRp();
    }
    
    public SpecificMetricsBuilder(MonitoringMetrics arg) {
        this._metricPce = arg.getMetricPce();
    }

    public SpecificMetricsBuilder(SpecificMetrics base) {
        Map<Class<? extends Augmentation<SpecificMetrics>>, Augmentation<SpecificMetrics>> aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._metricPce = base.getMetricPce();
        this._rp = base.getRp();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>MonitoringMetrics</li>
     * <li>RpObject</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof MonitoringMetrics) {
            this._metricPce = ((MonitoringMetrics)arg).getMetricPce();
            isValidArg = true;
        }
        if (arg instanceof RpObject) {
            this._rp = ((RpObject)arg).getRp();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[MonitoringMetrics, RpObject]");
    }

    public List<MetricPce> getMetricPce() {
        return _metricPce;
    }
    
    public Rp getRp() {
        return _rp;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<SpecificMetrics>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public SpecificMetricsBuilder setMetricPce(final List<MetricPce> values) {
        this._metricPce = values;
        return this;
    }
    
    
    public SpecificMetricsBuilder setRp(final Rp value) {
        this._rp = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public SpecificMetricsBuilder addAugmentation(Augmentation<SpecificMetrics> augmentation) {
        Class<? extends Augmentation<SpecificMetrics>> augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public SpecificMetricsBuilder removeAugmentation(Class<? extends Augmentation<SpecificMetrics>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public SpecificMetrics build() {
        return new SpecificMetricsImpl(this);
    }

    private static final class SpecificMetricsImpl
        extends AbstractAugmentable<SpecificMetrics>
        implements SpecificMetrics {
    
        private final List<MetricPce> _metricPce;
        private final Rp _rp;
    
        SpecificMetricsImpl(SpecificMetricsBuilder base) {
            super(base.augmentation);
            this._metricPce = CodeHelpers.emptyToNull(base.getMetricPce());
            this._rp = base.getRp();
        }
    
        @Override
        public List<MetricPce> getMetricPce() {
            return _metricPce;
        }
        
        @Override
        public Rp getRp() {
            return _rp;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = SpecificMetrics.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return SpecificMetrics.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return SpecificMetrics.bindingToString(this);
        }
    }
}
