package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.open.object;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Override;
import java.lang.String;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.OpenObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.ProtocolVersion;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.open.object.open.Tlvs;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.Uint8;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>pcep-types</b>
 * <pre>
 * container open {
 *   uses object;
 *   container tlvs {
 *     uses of-list-tlv;
 *     uses vendor-information-tlvs;
 *   }
 *   leaf version {
 *     type protocol-version;
 *     default 1;
 *   }
 *   leaf keepalive {
 *     type uint8 {
 *       range 0..255;
 *     }
 *   }
 *   leaf dead-timer {
 *     type uint8 {
 *       range 0..255;
 *     }
 *   }
 *   leaf session-id {
 *     type uint8;
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>pcep-typesopen-objectopen</i>
 *
 * <p>To create instances of this class use {@link OpenBuilder}.
 * @see OpenBuilder
 *
 */
@Generated("mdsal-binding-generator")
public interface Open
    extends
    ChildOf<OpenObject>,
    Augmentable<Open>,
    Object
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("open");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.open.object.Open> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.open.object.Open.class;
    }
    
    /**
     * Default implementation of {@link java.lang.Object#hashCode()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent hashing
     * results across all implementations.
     *
     * @param obj Object for which to generate hashCode() result.
     * @return Hash code value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static int bindingHashCode(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.open.object.@NonNull Open obj) {
        final int prime = 31;
        int result = 1;
        result = prime * result + Objects.hashCode(obj.getDeadTimer());
        result = prime * result + Objects.hashCode(obj.getIgnore());
        result = prime * result + Objects.hashCode(obj.getKeepalive());
        result = prime * result + Objects.hashCode(obj.getProcessingRule());
        result = prime * result + Objects.hashCode(obj.getSessionId());
        result = prime * result + Objects.hashCode(obj.getTlvs());
        result = prime * result + Objects.hashCode(obj.getVersion());
        for (var augmentation : obj.augmentations().values()) {
            result += augmentation.hashCode();
        }
        return result;
    }
    
    /**
     * Default implementation of {@link java.lang.Object#equals(java.lang.Object)} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent equality
     * results across all implementations.
     *
     * @param thisObj Object acting as the receiver of equals invocation
     * @param obj Object acting as argument to equals invocation
     * @return True if thisObj and obj are considered equal
     * @throws NullPointerException if {@code thisObj} is null
     */
    static boolean bindingEquals(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.open.object.@NonNull Open thisObj, final java.lang.Object obj) {
        if (thisObj == obj) {
            return true;
        }
        final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.open.object.Open other = CodeHelpers.checkCast(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.open.object.Open.class, obj);
        if (other == null) {
            return false;
        }
        if (!Objects.equals(thisObj.getDeadTimer(), other.getDeadTimer())) {
            return false;
        }
        if (!Objects.equals(thisObj.getIgnore(), other.getIgnore())) {
            return false;
        }
        if (!Objects.equals(thisObj.getKeepalive(), other.getKeepalive())) {
            return false;
        }
        if (!Objects.equals(thisObj.getProcessingRule(), other.getProcessingRule())) {
            return false;
        }
        if (!Objects.equals(thisObj.getSessionId(), other.getSessionId())) {
            return false;
        }
        if (!Objects.equals(thisObj.getVersion(), other.getVersion())) {
            return false;
        }
        if (!Objects.equals(thisObj.getTlvs(), other.getTlvs())) {
            return false;
        }
        return thisObj.augmentations().equals(other.augmentations());
    }
    
    /**
     * Default implementation of {@link java.lang.Object#toString()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent string
     * representations across all implementations.
     *
     * @param obj Object for which to generate toString() result.
     * @return {@link String} value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static String bindingToString(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.open.object.@NonNull Open obj) {
        final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("Open");
        CodeHelpers.appendValue(helper, "deadTimer", obj.getDeadTimer());
        CodeHelpers.appendValue(helper, "ignore", obj.getIgnore());
        CodeHelpers.appendValue(helper, "keepalive", obj.getKeepalive());
        CodeHelpers.appendValue(helper, "processingRule", obj.getProcessingRule());
        CodeHelpers.appendValue(helper, "sessionId", obj.getSessionId());
        CodeHelpers.appendValue(helper, "tlvs", obj.getTlvs());
        CodeHelpers.appendValue(helper, "version", obj.getVersion());
        CodeHelpers.appendAugmentations(helper, "augmentation", obj);
        return helper.toString();
    }
    
    /**
     * Return tlvs, or {@code null} if it is not present.
     *
     * @return {@code Tlvs} tlvs, or {@code null} if it is not present.
     *
     */
    Tlvs getTlvs();
    
    /**
     * Return version, or {@code null} if it is not present.
     *
     * @return {@code ProtocolVersion} version, or {@code null} if it is not present.
     *
     */
    ProtocolVersion getVersion();
    
    /**
     * Return version, guaranteed to be non-null.
     *
     * @return {@code ProtocolVersion} version, guaranteed to be non-null.
     * @throws NoSuchElementException if version is not present
     *
     */
    default @NonNull ProtocolVersion requireVersion() {
        return CodeHelpers.require(getVersion(), "version");
    }
    
    /**
     * Return keepalive, or {@code null} if it is not present.
     *
     * @return {@code Uint8} keepalive, or {@code null} if it is not present.
     *
     */
    Uint8 getKeepalive();
    
    /**
     * Return keepalive, guaranteed to be non-null.
     *
     * @return {@code Uint8} keepalive, guaranteed to be non-null.
     * @throws NoSuchElementException if keepalive is not present
     *
     */
    default @NonNull Uint8 requireKeepalive() {
        return CodeHelpers.require(getKeepalive(), "keepalive");
    }
    
    /**
     * Return deadTimer, or {@code null} if it is not present.
     *
     * @return {@code Uint8} deadTimer, or {@code null} if it is not present.
     *
     */
    Uint8 getDeadTimer();
    
    /**
     * Return deadTimer, guaranteed to be non-null.
     *
     * @return {@code Uint8} deadTimer, guaranteed to be non-null.
     * @throws NoSuchElementException if deadTimer is not present
     *
     */
    default @NonNull Uint8 requireDeadTimer() {
        return CodeHelpers.require(getDeadTimer(), "deadtimer");
    }
    
    /**
     * Return sessionId, or {@code null} if it is not present.
     *
     * @return {@code Uint8} sessionId, or {@code null} if it is not present.
     *
     */
    Uint8 getSessionId();
    
    /**
     * Return sessionId, guaranteed to be non-null.
     *
     * @return {@code Uint8} sessionId, guaranteed to be non-null.
     * @throws NoSuchElementException if sessionId is not present
     *
     */
    default @NonNull Uint8 requireSessionId() {
        return CodeHelpers.require(getSessionId(), "sessionid");
    }

}

