package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.open.object;
import java.lang.Boolean;
import java.lang.Class;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.ObjectHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.ProtocolVersion;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.open.object.open.Tlvs;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.Uint8;

/**
 * Class that builds {@link OpenBuilder} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     OpenBuilder createTarget(int fooXyzzy, int barBaz) {
 *         return new OpenBuilderBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of OpenBuilder, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization oportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see OpenBuilder
 * @see Builder
 *
 */
@Generated("mdsal-binding-generator")
public class OpenBuilder implements Builder<Open> {

    private Uint8 _deadTimer;
    private Boolean _ignore;
    private Uint8 _keepalive;
    private Boolean _processingRule;
    private Uint8 _sessionId;
    private Tlvs _tlvs;
    private ProtocolVersion _version;


    Map<Class<? extends Augmentation<Open>>, Augmentation<Open>> augmentation = Collections.emptyMap();

    public OpenBuilder() {
    }
    
    
    
    public OpenBuilder(Object arg) {
        this._processingRule = arg.getProcessingRule();
        this._ignore = arg.getIgnore();
    }
    public OpenBuilder(ObjectHeader arg) {
        this._processingRule = arg.getProcessingRule();
        this._ignore = arg.getIgnore();
    }

    public OpenBuilder(Open base) {
        Map<Class<? extends Augmentation<Open>>, Augmentation<Open>> aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._deadTimer = base.getDeadTimer();
        this._ignore = base.getIgnore();
        this._keepalive = base.getKeepalive();
        this._processingRule = base.getProcessingRule();
        this._sessionId = base.getSessionId();
        this._tlvs = base.getTlvs();
        this._version = base.getVersion();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>ObjectHeader</li>
     * <li>Object</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof ObjectHeader) {
            this._processingRule = ((ObjectHeader)arg).getProcessingRule();
            this._ignore = ((ObjectHeader)arg).getIgnore();
            isValidArg = true;
        }
        if (arg instanceof Object) {
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[ObjectHeader, Object]");
    }

    public Uint8 getDeadTimer() {
        return _deadTimer;
    }
    
    public Boolean getIgnore() {
        return _ignore;
    }
    
    public Uint8 getKeepalive() {
        return _keepalive;
    }
    
    public Boolean getProcessingRule() {
        return _processingRule;
    }
    
    public Uint8 getSessionId() {
        return _sessionId;
    }
    
    public Tlvs getTlvs() {
        return _tlvs;
    }
    
    public ProtocolVersion getVersion() {
        return _version;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<Open>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    private static void checkDeadTimerRange(final short value) {
    }
    
    public OpenBuilder setDeadTimer(final Uint8 value) {
        if (value != null) {
            checkDeadTimerRange(value.shortValue());
            
        }
        this._deadTimer = value;
        return this;
    }
    
    public OpenBuilder setIgnore(final Boolean value) {
        this._ignore = value;
        return this;
    }
    
    private static void checkKeepaliveRange(final short value) {
    }
    
    public OpenBuilder setKeepalive(final Uint8 value) {
        if (value != null) {
            checkKeepaliveRange(value.shortValue());
            
        }
        this._keepalive = value;
        return this;
    }
    
    public OpenBuilder setProcessingRule(final Boolean value) {
        this._processingRule = value;
        return this;
    }
    
    public OpenBuilder setSessionId(final Uint8 value) {
        this._sessionId = value;
        return this;
    }
    
    public OpenBuilder setTlvs(final Tlvs value) {
        this._tlvs = value;
        return this;
    }
    
    public OpenBuilder setVersion(final ProtocolVersion value) {
        this._version = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public OpenBuilder addAugmentation(Augmentation<Open> augmentation) {
        Class<? extends Augmentation<Open>> augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public OpenBuilder removeAugmentation(Class<? extends Augmentation<Open>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public Open build() {
        return new OpenImpl(this);
    }

    private static final class OpenImpl
        extends AbstractAugmentable<Open>
        implements Open {
    
        private final Uint8 _deadTimer;
        private final Boolean _ignore;
        private final Uint8 _keepalive;
        private final Boolean _processingRule;
        private final Uint8 _sessionId;
        private final Tlvs _tlvs;
        private final ProtocolVersion _version;
    
        OpenImpl(OpenBuilder base) {
            super(base.augmentation);
            this._deadTimer = base.getDeadTimer();
            this._ignore = base.getIgnore();
            this._keepalive = base.getKeepalive();
            this._processingRule = base.getProcessingRule();
            this._sessionId = base.getSessionId();
            this._tlvs = base.getTlvs();
            this._version = base.getVersion();
        }
    
        @Override
        public Uint8 getDeadTimer() {
            return _deadTimer;
        }
        
        @Override
        public Boolean getIgnore() {
            return _ignore;
        }
        
        @Override
        public Uint8 getKeepalive() {
            return _keepalive;
        }
        
        @Override
        public Boolean getProcessingRule() {
            return _processingRule;
        }
        
        @Override
        public Uint8 getSessionId() {
            return _sessionId;
        }
        
        @Override
        public Tlvs getTlvs() {
            return _tlvs;
        }
        
        @Override
        public ProtocolVersion getVersion() {
            return _version;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = Open.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(java.lang.Object obj) {
            return Open.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return Open.bindingToString(this);
        }
    }
}
