package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.order.tlv;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.OrderTlv;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Tlv;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.Uint32;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>pcep-types</b>
 * <pre>
 * container order {
 *   uses tlv;
 *   leaf delete {
 *     type uint32;
 *   }
 *   leaf setup {
 *     type uint32;
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>pcep-typesorder-tlvorder</i>
 *
 * <p>To create instances of this class use {@link OrderBuilder}.
 * @see OrderBuilder
 *
 */
@Generated("mdsal-binding-generator")
public interface Order
    extends
    ChildOf<OrderTlv>,
    Augmentable<Order>,
    Tlv
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("order");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.order.tlv.Order> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.order.tlv.Order.class;
    }
    
    /**
     * Default implementation of {@link Object#hashCode()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent hashing
     * results across all implementations.
     *
     * @param obj Object for which to generate hashCode() result.
     * @return Hash code value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static int bindingHashCode(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.order.tlv.@NonNull Order obj) {
        final int prime = 31;
        int result = 1;
        result = prime * result + Objects.hashCode(obj.getDelete());
        result = prime * result + Objects.hashCode(obj.getSetup());
        for (var augmentation : obj.augmentations().values()) {
            result += augmentation.hashCode();
        }
        return result;
    }
    
    /**
     * Default implementation of {@link Object#equals(Object)} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent equality
     * results across all implementations.
     *
     * @param thisObj Object acting as the receiver of equals invocation
     * @param obj Object acting as argument to equals invocation
     * @return True if thisObj and obj are considered equal
     * @throws NullPointerException if {@code thisObj} is null
     */
    static boolean bindingEquals(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.order.tlv.@NonNull Order thisObj, final Object obj) {
        if (thisObj == obj) {
            return true;
        }
        final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.order.tlv.Order other = CodeHelpers.checkCast(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.order.tlv.Order.class, obj);
        if (other == null) {
            return false;
        }
        if (!Objects.equals(thisObj.getDelete(), other.getDelete())) {
            return false;
        }
        if (!Objects.equals(thisObj.getSetup(), other.getSetup())) {
            return false;
        }
        return thisObj.augmentations().equals(other.augmentations());
    }
    
    /**
     * Default implementation of {@link Object#toString()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent string
     * representations across all implementations.
     *
     * @param obj Object for which to generate toString() result.
     * @return {@link String} value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static String bindingToString(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.order.tlv.@NonNull Order obj) {
        final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("Order");
        CodeHelpers.appendValue(helper, "delete", obj.getDelete());
        CodeHelpers.appendValue(helper, "setup", obj.getSetup());
        CodeHelpers.appendAugmentations(helper, "augmentation", obj);
        return helper.toString();
    }
    
    /**
     * Return delete, or {@code null} if it is not present.
     *
     * @return {@code Uint32} delete, or {@code null} if it is not present.
     *
     */
    Uint32 getDelete();
    
    /**
     * Return delete, guaranteed to be non-null.
     *
     * @return {@code Uint32} delete, guaranteed to be non-null.
     * @throws NoSuchElementException if delete is not present
     *
     */
    default @NonNull Uint32 requireDelete() {
        return CodeHelpers.require(getDelete(), "delete");
    }
    
    /**
     * Return setup, or {@code null} if it is not present.
     *
     * @return {@code Uint32} setup, or {@code null} if it is not present.
     *
     */
    Uint32 getSetup();
    
    /**
     * Return setup, guaranteed to be non-null.
     *
     * @return {@code Uint32} setup, guaranteed to be non-null.
     * @throws NoSuchElementException if setup is not present
     *
     */
    default @NonNull Uint32 requireSetup() {
        return CodeHelpers.require(getSetup(), "setup");
    }

}

