package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.path.key.object.path.key;
import java.lang.Boolean;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.CSubobject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.PathKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.PathKeySubobject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.PceId;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link PathKeysBuilder} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     PathKeysBuilder createTarget(int fooXyzzy, int barBaz) {
 *         return new PathKeysBuilderBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of PathKeysBuilder, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization oportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see PathKeysBuilder
 * @see Builder
 *
 */
@Generated("mdsal-binding-generator")
public class PathKeysBuilder implements Builder<PathKeys> {

    private Boolean _loose;
    private PathKey _pathKey;
    private PceId _pceId;


    Map<Class<? extends Augmentation<PathKeys>>, Augmentation<PathKeys>> augmentation = Collections.emptyMap();

    public PathKeysBuilder() {
    }
    
    
    
    public PathKeysBuilder(PathKeySubobject arg) {
        this._pceId = arg.getPceId();
        this._pathKey = arg.getPathKey();
    }
    public PathKeysBuilder(CSubobject arg) {
    }

    public PathKeysBuilder(PathKeys base) {
        Map<Class<? extends Augmentation<PathKeys>>, Augmentation<PathKeys>> aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._loose = base.getLoose();
        this._pathKey = base.getPathKey();
        this._pceId = base.getPceId();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>PathKeySubobject</li>
     * <li>CSubobject</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof PathKeySubobject) {
            this._pceId = ((PathKeySubobject)arg).getPceId();
            this._pathKey = ((PathKeySubobject)arg).getPathKey();
            isValidArg = true;
        }
        if (arg instanceof CSubobject) {
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[PathKeySubobject, CSubobject]");
    }

    public Boolean getLoose() {
        return _loose;
    }
    
    public PathKey getPathKey() {
        return _pathKey;
    }
    
    public PceId getPceId() {
        return _pceId;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<PathKeys>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    public PathKeysBuilder setLoose(final Boolean value) {
        this._loose = value;
        return this;
    }
    
    public PathKeysBuilder setPathKey(final PathKey value) {
        this._pathKey = value;
        return this;
    }
    
    public PathKeysBuilder setPceId(final PceId value) {
        this._pceId = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public PathKeysBuilder addAugmentation(Augmentation<PathKeys> augmentation) {
        Class<? extends Augmentation<PathKeys>> augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public PathKeysBuilder removeAugmentation(Class<? extends Augmentation<PathKeys>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public PathKeys build() {
        return new PathKeysImpl(this);
    }

    private static final class PathKeysImpl
        extends AbstractAugmentable<PathKeys>
        implements PathKeys {
    
        private final Boolean _loose;
        private final PathKey _pathKey;
        private final PceId _pceId;
    
        PathKeysImpl(PathKeysBuilder base) {
            super(base.augmentation);
            this._loose = base.getLoose();
            this._pathKey = base.getPathKey();
            this._pceId = base.getPceId();
        }
    
        @Override
        public Boolean getLoose() {
            return _loose;
        }
        
        @Override
        public PathKey getPathKey() {
            return _pathKey;
        }
        
        @Override
        public PceId getPceId() {
            return _pceId;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = PathKeys.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return PathKeys.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return PathKeys.bindingToString(this);
        }
    }
}
