package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcerr.message;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.MessageHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcerr.message.pcerr.message.ErrorType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcerr.message.pcerr.message.Errors;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Error Message
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>pcep-types</b>
 * <pre>
 * container pcerr-message {
 *   uses message-header;
 *   list errors {
 *     uses pcep-error-object;
 *   }
 *   choice error-type {
 *     case request-case {
 *       container request {
 *         list rps {
 *           uses rp-object;
 *         }
 *       }
 *     }
 *     case session-case {
 *       container session {
 *         uses open-object;
 *       }
 *     }
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>pcep-typespcerr-messagepcerr-message</i>
 *
 * <p>To create instances of this class use {@link PcerrMessageBuilder}.
 * @see PcerrMessageBuilder
 *
 */
@Generated("mdsal-binding-generator")
public interface PcerrMessage
    extends
    ChildOf<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.PcerrMessage>,
    Augmentable<PcerrMessage>,
    MessageHeader
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("pcerr-message");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcerr.message.PcerrMessage> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcerr.message.PcerrMessage.class;
    }
    
    /**
     * Default implementation of {@link Object#hashCode()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent hashing
     * results across all implementations.
     *
     * @param obj Object for which to generate hashCode() result.
     * @return Hash code value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static int bindingHashCode(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcerr.message.@NonNull PcerrMessage obj) {
        final int prime = 31;
        int result = 1;
        result = prime * result + Objects.hashCode(obj.getErrorType());
        result = prime * result + Objects.hashCode(obj.getErrors());
        result = prime * result + Objects.hashCode(obj.getVersion());
        for (var augmentation : obj.augmentations().values()) {
            result += augmentation.hashCode();
        }
        return result;
    }
    
    /**
     * Default implementation of {@link Object#equals(Object)} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent equality
     * results across all implementations.
     *
     * @param thisObj Object acting as the receiver of equals invocation
     * @param obj Object acting as argument to equals invocation
     * @return True if thisObj and obj are considered equal
     * @throws NullPointerException if {@code thisObj} is null
     */
    static boolean bindingEquals(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcerr.message.@NonNull PcerrMessage thisObj, final Object obj) {
        if (thisObj == obj) {
            return true;
        }
        final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcerr.message.PcerrMessage other = CodeHelpers.checkCast(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcerr.message.PcerrMessage.class, obj);
        if (other == null) {
            return false;
        }
        if (!Objects.equals(thisObj.getVersion(), other.getVersion())) {
            return false;
        }
        if (!Objects.equals(thisObj.getErrorType(), other.getErrorType())) {
            return false;
        }
        if (!Objects.equals(thisObj.getErrors(), other.getErrors())) {
            return false;
        }
        return thisObj.augmentations().equals(other.augmentations());
    }
    
    /**
     * Default implementation of {@link Object#toString()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent string
     * representations across all implementations.
     *
     * @param obj Object for which to generate toString() result.
     * @return {@link String} value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static String bindingToString(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcerr.message.@NonNull PcerrMessage obj) {
        final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("PcerrMessage");
        CodeHelpers.appendValue(helper, "errorType", obj.getErrorType());
        CodeHelpers.appendValue(helper, "errors", obj.getErrors());
        CodeHelpers.appendValue(helper, "version", obj.getVersion());
        CodeHelpers.appendAugmentations(helper, "augmentation", obj);
        return helper.toString();
    }
    
    /**
     * Return errors, or {@code null} if it is not present.
     *
     * @return {@code List<Errors>} errors, or {@code null} if it is not present.
     *
     */
    @Nullable List<Errors> getErrors();
    
    /**
     * Return errors, or an empty list if it is not present.
     *
     * @return {@code List<Errors>} errors, or an empty list if it is not present.
     *
     */
    default @NonNull List<Errors> nonnullErrors() {
        return CodeHelpers.nonnull(getErrors());
    }
    
    /**
     * Return errorType, or {@code null} if it is not present.
     *
     * @return {@code ErrorType} errorType, or {@code null} if it is not present.
     *
     */
    ErrorType getErrorType();

}

