package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcmonrep.message;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.MonitoringObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.MonitoringResponse;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.PccIdReqObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.monitoring.object.Monitoring;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.monitoring.response.MonitoringMetricsList;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcc.id.req.object.PccIdReq;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link PcmonrepMessageBuilder} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     PcmonrepMessageBuilder createTarget(int fooXyzzy, int barBaz) {
 *         return new PcmonrepMessageBuilderBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of PcmonrepMessageBuilder, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization oportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see PcmonrepMessageBuilder
 * @see Builder
 *
 */
@Generated("mdsal-binding-generator")
public class PcmonrepMessageBuilder implements Builder<PcmonrepMessage> {

    private Monitoring _monitoring;
    private MonitoringMetricsList _monitoringMetricsList;
    private PccIdReq _pccIdReq;


    Map<Class<? extends Augmentation<PcmonrepMessage>>, Augmentation<PcmonrepMessage>> augmentation = Collections.emptyMap();

    public PcmonrepMessageBuilder() {
    }
    
    
    
    public PcmonrepMessageBuilder(MonitoringResponse arg) {
        this._monitoringMetricsList = arg.getMonitoringMetricsList();
        this._monitoring = arg.getMonitoring();
        this._pccIdReq = arg.getPccIdReq();
    }
    public PcmonrepMessageBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Monitoring arg) {
        this._monitoring = arg.getMonitoring();
        this._pccIdReq = arg.getPccIdReq();
    }
    public PcmonrepMessageBuilder(MonitoringObject arg) {
        this._monitoring = arg.getMonitoring();
    }
    public PcmonrepMessageBuilder(PccIdReqObject arg) {
        this._pccIdReq = arg.getPccIdReq();
    }

    public PcmonrepMessageBuilder(PcmonrepMessage base) {
        Map<Class<? extends Augmentation<PcmonrepMessage>>, Augmentation<PcmonrepMessage>> aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._monitoring = base.getMonitoring();
        this._monitoringMetricsList = base.getMonitoringMetricsList();
        this._pccIdReq = base.getPccIdReq();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>PccIdReqObject</li>
     * <li>MonitoringObject</li>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Monitoring</li>
     * <li>MonitoringResponse</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof PccIdReqObject) {
            this._pccIdReq = ((PccIdReqObject)arg).getPccIdReq();
            isValidArg = true;
        }
        if (arg instanceof MonitoringObject) {
            this._monitoring = ((MonitoringObject)arg).getMonitoring();
            isValidArg = true;
        }
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Monitoring) {
            isValidArg = true;
        }
        if (arg instanceof MonitoringResponse) {
            this._monitoringMetricsList = ((MonitoringResponse)arg).getMonitoringMetricsList();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[PccIdReqObject, MonitoringObject, org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Monitoring, MonitoringResponse]");
    }

    public Monitoring getMonitoring() {
        return _monitoring;
    }
    
    public MonitoringMetricsList getMonitoringMetricsList() {
        return _monitoringMetricsList;
    }
    
    public PccIdReq getPccIdReq() {
        return _pccIdReq;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<PcmonrepMessage>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    public PcmonrepMessageBuilder setMonitoring(final Monitoring value) {
        this._monitoring = value;
        return this;
    }
    
    public PcmonrepMessageBuilder setMonitoringMetricsList(final MonitoringMetricsList value) {
        this._monitoringMetricsList = value;
        return this;
    }
    
    public PcmonrepMessageBuilder setPccIdReq(final PccIdReq value) {
        this._pccIdReq = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public PcmonrepMessageBuilder addAugmentation(Augmentation<PcmonrepMessage> augmentation) {
        Class<? extends Augmentation<PcmonrepMessage>> augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public PcmonrepMessageBuilder removeAugmentation(Class<? extends Augmentation<PcmonrepMessage>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public PcmonrepMessage build() {
        return new PcmonrepMessageImpl(this);
    }

    private static final class PcmonrepMessageImpl
        extends AbstractAugmentable<PcmonrepMessage>
        implements PcmonrepMessage {
    
        private final Monitoring _monitoring;
        private final MonitoringMetricsList _monitoringMetricsList;
        private final PccIdReq _pccIdReq;
    
        PcmonrepMessageImpl(PcmonrepMessageBuilder base) {
            super(base.augmentation);
            this._monitoring = base.getMonitoring();
            this._monitoringMetricsList = base.getMonitoringMetricsList();
            this._pccIdReq = base.getPccIdReq();
        }
    
        @Override
        public Monitoring getMonitoring() {
            return _monitoring;
        }
        
        @Override
        public MonitoringMetricsList getMonitoringMetricsList() {
            return _monitoringMetricsList;
        }
        
        @Override
        public PccIdReq getPccIdReq() {
            return _pccIdReq;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = PcmonrepMessage.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return PcmonrepMessage.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return PcmonrepMessage.bindingToString(this);
        }
    }
}
