package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcrep.message;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.MessageHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcrep.message.pcrep.message.Replies;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Path Computation Reply Message
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>pcep-types</b>
 * <pre>
 * container pcrep-message {
 *   uses message-header;
 *   list replies {
 *     uses rp-object;
 *     uses vendor-information-objects;
 *     uses monitoring;
 *     uses monitoring-metrics;
 *     choice result {
 *       case success-case {
 *         container success {
 *           list paths {
 *             uses path-definition;
 *           }
 *           uses vendor-information-objects;
 *         }
 *       }
 *       case failure-case {
 *         container no-path {
 *           uses no-path-object;
 *           container tlvs {
 *             uses vendor-information-tlvs;
 *             container no-path-vector {
 *               uses no-path-vector-tlv;
 *             }
 *           }
 *         }
 *         uses lsp-attributes;
 *       }
 *     }
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>pcep-typespcrep-messagepcrep-message</i>
 *
 * <p>To create instances of this class use {@link PcrepMessageBuilder}.
 * @see PcrepMessageBuilder
 *
 */
@Generated("mdsal-binding-generator")
public interface PcrepMessage
    extends
    ChildOf<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.PcrepMessage>,
    Augmentable<PcrepMessage>,
    MessageHeader
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("pcrep-message");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcrep.message.PcrepMessage> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcrep.message.PcrepMessage.class;
    }
    
    /**
     * Default implementation of {@link Object#hashCode()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent hashing
     * results across all implementations.
     *
     * @param obj Object for which to generate hashCode() result.
     * @return Hash code value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static int bindingHashCode(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcrep.message.@NonNull PcrepMessage obj) {
        final int prime = 31;
        int result = 1;
        result = prime * result + Objects.hashCode(obj.getReplies());
        result = prime * result + Objects.hashCode(obj.getVersion());
        for (var augmentation : obj.augmentations().values()) {
            result += augmentation.hashCode();
        }
        return result;
    }
    
    /**
     * Default implementation of {@link Object#equals(Object)} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent equality
     * results across all implementations.
     *
     * @param thisObj Object acting as the receiver of equals invocation
     * @param obj Object acting as argument to equals invocation
     * @return True if thisObj and obj are considered equal
     * @throws NullPointerException if {@code thisObj} is null
     */
    static boolean bindingEquals(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcrep.message.@NonNull PcrepMessage thisObj, final Object obj) {
        if (thisObj == obj) {
            return true;
        }
        final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcrep.message.PcrepMessage other = CodeHelpers.checkCast(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcrep.message.PcrepMessage.class, obj);
        if (other == null) {
            return false;
        }
        if (!Objects.equals(thisObj.getVersion(), other.getVersion())) {
            return false;
        }
        if (!Objects.equals(thisObj.getReplies(), other.getReplies())) {
            return false;
        }
        return thisObj.augmentations().equals(other.augmentations());
    }
    
    /**
     * Default implementation of {@link Object#toString()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent string
     * representations across all implementations.
     *
     * @param obj Object for which to generate toString() result.
     * @return {@link String} value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static String bindingToString(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcrep.message.@NonNull PcrepMessage obj) {
        final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("PcrepMessage");
        CodeHelpers.appendValue(helper, "replies", obj.getReplies());
        CodeHelpers.appendValue(helper, "version", obj.getVersion());
        CodeHelpers.appendAugmentations(helper, "augmentation", obj);
        return helper.toString();
    }
    
    /**
     * Return replies, or {@code null} if it is not present.
     *
     * @return {@code List<Replies>} replies, or {@code null} if it is not present.
     *
     */
    @Nullable List<Replies> getReplies();
    
    /**
     * Return replies, or an empty list if it is not present.
     *
     * @return {@code List<Replies>} replies, or an empty list if it is not present.
     *
     */
    default @NonNull List<Replies> nonnullReplies() {
        return CodeHelpers.nonnull(getReplies());
    }

}

