package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcrep.message.pcrep.message;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Monitoring;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.MonitoringMetrics;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.RpObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.VendorInformationObjects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcrep.message.PcrepMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcrep.message.pcrep.message.replies.Result;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>pcep-types</b>
 * <pre>
 * list replies {
 *   uses rp-object;
 *   uses vendor-information-objects;
 *   uses monitoring;
 *   uses monitoring-metrics;
 *   choice result {
 *     case success-case {
 *       container success {
 *         list paths {
 *           uses path-definition;
 *         }
 *         uses vendor-information-objects;
 *       }
 *     }
 *     case failure-case {
 *       container no-path {
 *         uses no-path-object;
 *         container tlvs {
 *           uses vendor-information-tlvs;
 *           container no-path-vector {
 *             uses no-path-vector-tlv;
 *           }
 *         }
 *       }
 *       uses lsp-attributes;
 *     }
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>pcep-typespcrep-messagepcrep-messagereplies</i>
 *
 * <p>To create instances of this class use {@link RepliesBuilder}.
 * @see RepliesBuilder
 *
 *
 */
@Generated("mdsal-binding-generator")
public interface Replies
    extends
    ChildOf<PcrepMessage>,
    Augmentable<Replies>,
    RpObject,
    VendorInformationObjects,
    Monitoring,
    MonitoringMetrics
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("replies");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcrep.message.pcrep.message.Replies> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcrep.message.pcrep.message.Replies.class;
    }
    
    /**
     * Default implementation of {@link Object#hashCode()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent hashing
     * results across all implementations.
     *
     * @param obj Object for which to generate hashCode() result.
     * @return Hash code value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static int bindingHashCode(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcrep.message.pcrep.message.@NonNull Replies obj) {
        final int prime = 31;
        int result = 1;
        result = prime * result + Objects.hashCode(obj.getMetricPce());
        result = prime * result + Objects.hashCode(obj.getMonitoring());
        result = prime * result + Objects.hashCode(obj.getPccIdReq());
        result = prime * result + Objects.hashCode(obj.getResult());
        result = prime * result + Objects.hashCode(obj.getRp());
        result = prime * result + Objects.hashCode(obj.getVendorInformationObject());
        for (var augmentation : obj.augmentations().values()) {
            result += augmentation.hashCode();
        }
        return result;
    }
    
    /**
     * Default implementation of {@link Object#equals(Object)} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent equality
     * results across all implementations.
     *
     * @param thisObj Object acting as the receiver of equals invocation
     * @param obj Object acting as argument to equals invocation
     * @return True if thisObj and obj are considered equal
     * @throws NullPointerException if {@code thisObj} is null
     */
    static boolean bindingEquals(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcrep.message.pcrep.message.@NonNull Replies thisObj, final Object obj) {
        if (thisObj == obj) {
            return true;
        }
        final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcrep.message.pcrep.message.Replies other = CodeHelpers.checkCast(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcrep.message.pcrep.message.Replies.class, obj);
        if (other == null) {
            return false;
        }
        if (!Objects.equals(thisObj.getMetricPce(), other.getMetricPce())) {
            return false;
        }
        if (!Objects.equals(thisObj.getMonitoring(), other.getMonitoring())) {
            return false;
        }
        if (!Objects.equals(thisObj.getPccIdReq(), other.getPccIdReq())) {
            return false;
        }
        if (!Objects.equals(thisObj.getResult(), other.getResult())) {
            return false;
        }
        if (!Objects.equals(thisObj.getRp(), other.getRp())) {
            return false;
        }
        if (!Objects.equals(thisObj.getVendorInformationObject(), other.getVendorInformationObject())) {
            return false;
        }
        return thisObj.augmentations().equals(other.augmentations());
    }
    
    /**
     * Default implementation of {@link Object#toString()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent string
     * representations across all implementations.
     *
     * @param obj Object for which to generate toString() result.
     * @return {@link String} value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static String bindingToString(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcrep.message.pcrep.message.@NonNull Replies obj) {
        final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("Replies");
        CodeHelpers.appendValue(helper, "metricPce", obj.getMetricPce());
        CodeHelpers.appendValue(helper, "monitoring", obj.getMonitoring());
        CodeHelpers.appendValue(helper, "pccIdReq", obj.getPccIdReq());
        CodeHelpers.appendValue(helper, "result", obj.getResult());
        CodeHelpers.appendValue(helper, "rp", obj.getRp());
        CodeHelpers.appendValue(helper, "vendorInformationObject", obj.getVendorInformationObject());
        CodeHelpers.appendAugmentations(helper, "augmentation", obj);
        return helper.toString();
    }
    
    /**
     * Return result, or {@code null} if it is not present.
     *
     * @return {@code Result} result, or {@code null} if it is not present.
     *
     */
    Result getResult();

}

