package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcrep.message.pcrep.message.replies.result.failure._case;
import java.lang.Boolean;
import java.lang.Class;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.NoPathObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.ObjectHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcrep.message.pcrep.message.replies.result.failure._case.no.path.Tlvs;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.Uint8;

/**
 * Class that builds {@link NoPathBuilder} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     NoPathBuilder createTarget(int fooXyzzy, int barBaz) {
 *         return new NoPathBuilderBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of NoPathBuilder, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization oportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see NoPathBuilder
 * @see Builder
 *
 */
@Generated("mdsal-binding-generator")
public class NoPathBuilder implements Builder<NoPath> {

    private Boolean _ignore;
    private Uint8 _natureOfIssue;
    private Boolean _processingRule;
    private Tlvs _tlvs;
    private Boolean _unsatisfiedConstraints;


    Map<Class<? extends Augmentation<NoPath>>, Augmentation<NoPath>> augmentation = Collections.emptyMap();

    public NoPathBuilder() {
    }
    
    
    
    public NoPathBuilder(NoPathObject arg) {
        this._natureOfIssue = arg.getNatureOfIssue();
        this._unsatisfiedConstraints = arg.getUnsatisfiedConstraints();
        this._processingRule = arg.getProcessingRule();
        this._ignore = arg.getIgnore();
    }
    public NoPathBuilder(Object arg) {
        this._processingRule = arg.getProcessingRule();
        this._ignore = arg.getIgnore();
    }
    public NoPathBuilder(ObjectHeader arg) {
        this._processingRule = arg.getProcessingRule();
        this._ignore = arg.getIgnore();
    }

    public NoPathBuilder(NoPath base) {
        Map<Class<? extends Augmentation<NoPath>>, Augmentation<NoPath>> aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._ignore = base.getIgnore();
        this._natureOfIssue = base.getNatureOfIssue();
        this._processingRule = base.getProcessingRule();
        this._tlvs = base.getTlvs();
        this._unsatisfiedConstraints = base.getUnsatisfiedConstraints();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>ObjectHeader</li>
     * <li>NoPathObject</li>
     * <li>Object</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof ObjectHeader) {
            this._processingRule = ((ObjectHeader)arg).getProcessingRule();
            this._ignore = ((ObjectHeader)arg).getIgnore();
            isValidArg = true;
        }
        if (arg instanceof NoPathObject) {
            this._natureOfIssue = ((NoPathObject)arg).getNatureOfIssue();
            this._unsatisfiedConstraints = ((NoPathObject)arg).getUnsatisfiedConstraints();
            isValidArg = true;
        }
        if (arg instanceof Object) {
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[ObjectHeader, NoPathObject, Object]");
    }

    public Boolean getIgnore() {
        return _ignore;
    }
    
    public Uint8 getNatureOfIssue() {
        return _natureOfIssue;
    }
    
    public Boolean getProcessingRule() {
        return _processingRule;
    }
    
    public Tlvs getTlvs() {
        return _tlvs;
    }
    
    public Boolean getUnsatisfiedConstraints() {
        return _unsatisfiedConstraints;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<NoPath>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    public NoPathBuilder setIgnore(final Boolean value) {
        this._ignore = value;
        return this;
    }
    
    public NoPathBuilder setNatureOfIssue(final Uint8 value) {
        this._natureOfIssue = value;
        return this;
    }
    
    public NoPathBuilder setProcessingRule(final Boolean value) {
        this._processingRule = value;
        return this;
    }
    
    public NoPathBuilder setTlvs(final Tlvs value) {
        this._tlvs = value;
        return this;
    }
    
    public NoPathBuilder setUnsatisfiedConstraints(final Boolean value) {
        this._unsatisfiedConstraints = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public NoPathBuilder addAugmentation(Augmentation<NoPath> augmentation) {
        Class<? extends Augmentation<NoPath>> augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public NoPathBuilder removeAugmentation(Class<? extends Augmentation<NoPath>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public NoPath build() {
        return new NoPathImpl(this);
    }

    private static final class NoPathImpl
        extends AbstractAugmentable<NoPath>
        implements NoPath {
    
        private final Boolean _ignore;
        private final Uint8 _natureOfIssue;
        private final Boolean _processingRule;
        private final Tlvs _tlvs;
        private final Boolean _unsatisfiedConstraints;
    
        NoPathImpl(NoPathBuilder base) {
            super(base.augmentation);
            this._ignore = base.getIgnore();
            this._natureOfIssue = base.getNatureOfIssue();
            this._processingRule = base.getProcessingRule();
            this._tlvs = base.getTlvs();
            this._unsatisfiedConstraints = base.getUnsatisfiedConstraints();
        }
    
        @Override
        public Boolean getIgnore() {
            return _ignore;
        }
        
        @Override
        public Uint8 getNatureOfIssue() {
            return _natureOfIssue;
        }
        
        @Override
        public Boolean getProcessingRule() {
            return _processingRule;
        }
        
        @Override
        public Tlvs getTlvs() {
            return _tlvs;
        }
        
        @Override
        public Boolean getUnsatisfiedConstraints() {
            return _unsatisfiedConstraints;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = NoPath.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(java.lang.Object obj) {
            return NoPath.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return NoPath.bindingToString(this);
        }
    }
}
