package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcrep.message.pcrep.message.replies.result.success._case.success;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.BandwidthObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.ClasstypeObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.ExcludeRouteObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.ExplicitRouteObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.IncludeRouteObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.LspAttributes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.LspaObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.OfObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.PathDefinition;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.ReoptimizationBandwidthObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.ReportedRouteObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.bandwidth.object.Bandwidth;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.classtype.object.ClassType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.exclude.route.object.Xro;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.explicit.route.object.Ero;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.include.route.object.Iro;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.lsp.attributes.Metrics;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.lspa.object.Lspa;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.of.object.Of;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.reoptimization.bandwidth.object.ReoptimizationBandwidth;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.reported.route.object.Rro;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link PathsBuilder} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     PathsBuilder createTarget(int fooXyzzy, int barBaz) {
 *         return new PathsBuilderBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of PathsBuilder, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization oportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see PathsBuilder
 * @see Builder
 *
 */
@Generated("mdsal-binding-generator")
public class PathsBuilder implements Builder<Paths> {

    private Bandwidth _bandwidth;
    private ClassType _classType;
    private Ero _ero;
    private Iro _iro;
    private Lspa _lspa;
    private List<Metrics> _metrics;
    private Of _of;
    private ReoptimizationBandwidth _reoptimizationBandwidth;
    private Rro _rro;
    private Xro _xro;


    Map<Class<? extends Augmentation<Paths>>, Augmentation<Paths>> augmentation = Collections.emptyMap();

    public PathsBuilder() {
    }
    
    
    
    public PathsBuilder(PathDefinition arg) {
        this._ero = arg.getEro();
        this._metrics = arg.getMetrics();
        this._lspa = arg.getLspa();
        this._bandwidth = arg.getBandwidth();
        this._reoptimizationBandwidth = arg.getReoptimizationBandwidth();
        this._iro = arg.getIro();
        this._rro = arg.getRro();
        this._xro = arg.getXro();
        this._of = arg.getOf();
        this._classType = arg.getClassType();
    }
    public PathsBuilder(ExplicitRouteObject arg) {
        this._ero = arg.getEro();
    }
    public PathsBuilder(LspAttributes arg) {
        this._metrics = arg.getMetrics();
        this._lspa = arg.getLspa();
        this._bandwidth = arg.getBandwidth();
        this._reoptimizationBandwidth = arg.getReoptimizationBandwidth();
        this._iro = arg.getIro();
        this._rro = arg.getRro();
        this._xro = arg.getXro();
        this._of = arg.getOf();
        this._classType = arg.getClassType();
    }
    public PathsBuilder(LspaObject arg) {
        this._lspa = arg.getLspa();
    }
    public PathsBuilder(BandwidthObject arg) {
        this._bandwidth = arg.getBandwidth();
    }
    public PathsBuilder(ReoptimizationBandwidthObject arg) {
        this._reoptimizationBandwidth = arg.getReoptimizationBandwidth();
    }
    public PathsBuilder(IncludeRouteObject arg) {
        this._iro = arg.getIro();
    }
    public PathsBuilder(ReportedRouteObject arg) {
        this._rro = arg.getRro();
    }
    public PathsBuilder(ExcludeRouteObject arg) {
        this._xro = arg.getXro();
    }
    public PathsBuilder(OfObject arg) {
        this._of = arg.getOf();
    }
    public PathsBuilder(ClasstypeObject arg) {
        this._classType = arg.getClassType();
    }

    public PathsBuilder(Paths base) {
        Map<Class<? extends Augmentation<Paths>>, Augmentation<Paths>> aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._bandwidth = base.getBandwidth();
        this._classType = base.getClassType();
        this._ero = base.getEro();
        this._iro = base.getIro();
        this._lspa = base.getLspa();
        this._metrics = base.getMetrics();
        this._of = base.getOf();
        this._reoptimizationBandwidth = base.getReoptimizationBandwidth();
        this._rro = base.getRro();
        this._xro = base.getXro();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>ClasstypeObject</li>
     * <li>ReoptimizationBandwidthObject</li>
     * <li>BandwidthObject</li>
     * <li>OfObject</li>
     * <li>PathDefinition</li>
     * <li>ReportedRouteObject</li>
     * <li>LspAttributes</li>
     * <li>IncludeRouteObject</li>
     * <li>ExcludeRouteObject</li>
     * <li>LspaObject</li>
     * <li>ExplicitRouteObject</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof ClasstypeObject) {
            this._classType = ((ClasstypeObject)arg).getClassType();
            isValidArg = true;
        }
        if (arg instanceof ReoptimizationBandwidthObject) {
            this._reoptimizationBandwidth = ((ReoptimizationBandwidthObject)arg).getReoptimizationBandwidth();
            isValidArg = true;
        }
        if (arg instanceof BandwidthObject) {
            this._bandwidth = ((BandwidthObject)arg).getBandwidth();
            isValidArg = true;
        }
        if (arg instanceof OfObject) {
            this._of = ((OfObject)arg).getOf();
            isValidArg = true;
        }
        if (arg instanceof PathDefinition) {
            isValidArg = true;
        }
        if (arg instanceof ReportedRouteObject) {
            this._rro = ((ReportedRouteObject)arg).getRro();
            isValidArg = true;
        }
        if (arg instanceof LspAttributes) {
            this._metrics = ((LspAttributes)arg).getMetrics();
            isValidArg = true;
        }
        if (arg instanceof IncludeRouteObject) {
            this._iro = ((IncludeRouteObject)arg).getIro();
            isValidArg = true;
        }
        if (arg instanceof ExcludeRouteObject) {
            this._xro = ((ExcludeRouteObject)arg).getXro();
            isValidArg = true;
        }
        if (arg instanceof LspaObject) {
            this._lspa = ((LspaObject)arg).getLspa();
            isValidArg = true;
        }
        if (arg instanceof ExplicitRouteObject) {
            this._ero = ((ExplicitRouteObject)arg).getEro();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[ClasstypeObject, ReoptimizationBandwidthObject, BandwidthObject, OfObject, PathDefinition, ReportedRouteObject, LspAttributes, IncludeRouteObject, ExcludeRouteObject, LspaObject, ExplicitRouteObject]");
    }

    public Bandwidth getBandwidth() {
        return _bandwidth;
    }
    
    public ClassType getClassType() {
        return _classType;
    }
    
    public Ero getEro() {
        return _ero;
    }
    
    public Iro getIro() {
        return _iro;
    }
    
    public Lspa getLspa() {
        return _lspa;
    }
    
    public List<Metrics> getMetrics() {
        return _metrics;
    }
    
    public Of getOf() {
        return _of;
    }
    
    public ReoptimizationBandwidth getReoptimizationBandwidth() {
        return _reoptimizationBandwidth;
    }
    
    public Rro getRro() {
        return _rro;
    }
    
    public Xro getXro() {
        return _xro;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<Paths>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    public PathsBuilder setBandwidth(final Bandwidth value) {
        this._bandwidth = value;
        return this;
    }
    
    public PathsBuilder setClassType(final ClassType value) {
        this._classType = value;
        return this;
    }
    
    public PathsBuilder setEro(final Ero value) {
        this._ero = value;
        return this;
    }
    
    public PathsBuilder setIro(final Iro value) {
        this._iro = value;
        return this;
    }
    
    public PathsBuilder setLspa(final Lspa value) {
        this._lspa = value;
        return this;
    }
    public PathsBuilder setMetrics(final List<Metrics> values) {
        this._metrics = values;
        return this;
    }
    
    
    public PathsBuilder setOf(final Of value) {
        this._of = value;
        return this;
    }
    
    public PathsBuilder setReoptimizationBandwidth(final ReoptimizationBandwidth value) {
        this._reoptimizationBandwidth = value;
        return this;
    }
    
    public PathsBuilder setRro(final Rro value) {
        this._rro = value;
        return this;
    }
    
    public PathsBuilder setXro(final Xro value) {
        this._xro = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public PathsBuilder addAugmentation(Augmentation<Paths> augmentation) {
        Class<? extends Augmentation<Paths>> augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public PathsBuilder removeAugmentation(Class<? extends Augmentation<Paths>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public Paths build() {
        return new PathsImpl(this);
    }

    private static final class PathsImpl
        extends AbstractAugmentable<Paths>
        implements Paths {
    
        private final Bandwidth _bandwidth;
        private final ClassType _classType;
        private final Ero _ero;
        private final Iro _iro;
        private final Lspa _lspa;
        private final List<Metrics> _metrics;
        private final Of _of;
        private final ReoptimizationBandwidth _reoptimizationBandwidth;
        private final Rro _rro;
        private final Xro _xro;
    
        PathsImpl(PathsBuilder base) {
            super(base.augmentation);
            this._bandwidth = base.getBandwidth();
            this._classType = base.getClassType();
            this._ero = base.getEro();
            this._iro = base.getIro();
            this._lspa = base.getLspa();
            this._metrics = CodeHelpers.emptyToNull(base.getMetrics());
            this._of = base.getOf();
            this._reoptimizationBandwidth = base.getReoptimizationBandwidth();
            this._rro = base.getRro();
            this._xro = base.getXro();
        }
    
        @Override
        public Bandwidth getBandwidth() {
            return _bandwidth;
        }
        
        @Override
        public ClassType getClassType() {
            return _classType;
        }
        
        @Override
        public Ero getEro() {
            return _ero;
        }
        
        @Override
        public Iro getIro() {
            return _iro;
        }
        
        @Override
        public Lspa getLspa() {
            return _lspa;
        }
        
        @Override
        public List<Metrics> getMetrics() {
            return _metrics;
        }
        
        @Override
        public Of getOf() {
            return _of;
        }
        
        @Override
        public ReoptimizationBandwidth getReoptimizationBandwidth() {
            return _reoptimizationBandwidth;
        }
        
        @Override
        public Rro getRro() {
            return _rro;
        }
        
        @Override
        public Xro getXro() {
            return _xro;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = Paths.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return Paths.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return Paths.bindingToString(this);
        }
    }
}
