package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcreq.message;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.MessageHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcreq.message.pcreq.message.MonitoringRequest;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcreq.message.pcreq.message.Requests;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcreq.message.pcreq.message.Svec;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Path Computation Request Message
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>pcep-types</b>
 * <pre>
 * container pcreq-message {
 *   uses message-header;
 *   list requests {
 *     uses rp-object;
 *     container path-key-expansion {
 *       when "rp/path-key = true";
 *       uses path-key-object;
 *     }
 *     container segment-computation {
 *       when "rp/path-key = false";
 *       container p2p {
 *         when "../rp/p2mp = false";
 *         uses endpoints-object;
 *         container reported-route {
 *           uses reported-route-object;
 *           uses reoptimization-bandwidth-object;
 *         }
 *         uses vendor-information-objects;
 *         uses load-balancing-object;
 *         uses lsp-attributes;
 *       }
 *       container p2mp {
 *         when "../rp/p2mp = true";
 *         list endpoint-rro-pair {
 *           uses endpoints-object;
 *           list rros {
 *             choice route-object {
 *               case reported-route-object-case {
 *                 uses reported-route-object;
 *               }
 *               case secondary-reported-route-object-case {
 *                 uses secondary-reported-route-object;
 *               }
 *             }
 *           }
 *           uses reoptimization-bandwidth-object;
 *           min-elements 1;
 *         }
 *         uses of-object;
 *         uses lspa-object;
 *         uses bandwidth-object;
 *         list metric {
 *           uses metric-object;
 *         }
 *         choice iro-bnc-choice {
 *           case iro-case {
 *             uses include-route-object;
 *           }
 *           case bnc-case {
 *             uses bnc-object;
 *           }
 *         }
 *         uses load-balancing-object;
 *       }
 *     }
 *     uses vendor-information-objects;
 *   }
 *   list svec {
 *     uses svec-object;
 *     uses of-object;
 *     uses gc-object;
 *     uses exclude-route-object;
 *     list metric {
 *       uses metric-object;
 *     }
 *     uses vendor-information-objects;
 *   }
 *   container monitoring-request {
 *     uses monitoring;
 *     list pce-id-list {
 *       uses pce-id-object;
 *     }
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>pcep-typespcreq-messagepcreq-message</i>
 *
 * <p>To create instances of this class use {@link PcreqMessageBuilder}.
 * @see PcreqMessageBuilder
 *
 */
@Generated("mdsal-binding-generator")
public interface PcreqMessage
    extends
    ChildOf<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.PcreqMessage>,
    Augmentable<PcreqMessage>,
    MessageHeader
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("pcreq-message");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcreq.message.PcreqMessage> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcreq.message.PcreqMessage.class;
    }
    
    /**
     * Default implementation of {@link Object#hashCode()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent hashing
     * results across all implementations.
     *
     * @param obj Object for which to generate hashCode() result.
     * @return Hash code value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static int bindingHashCode(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcreq.message.@NonNull PcreqMessage obj) {
        final int prime = 31;
        int result = 1;
        result = prime * result + Objects.hashCode(obj.getMonitoringRequest());
        result = prime * result + Objects.hashCode(obj.getRequests());
        result = prime * result + Objects.hashCode(obj.getSvec());
        result = prime * result + Objects.hashCode(obj.getVersion());
        for (var augmentation : obj.augmentations().values()) {
            result += augmentation.hashCode();
        }
        return result;
    }
    
    /**
     * Default implementation of {@link Object#equals(Object)} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent equality
     * results across all implementations.
     *
     * @param thisObj Object acting as the receiver of equals invocation
     * @param obj Object acting as argument to equals invocation
     * @return True if thisObj and obj are considered equal
     * @throws NullPointerException if {@code thisObj} is null
     */
    static boolean bindingEquals(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcreq.message.@NonNull PcreqMessage thisObj, final Object obj) {
        if (thisObj == obj) {
            return true;
        }
        final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcreq.message.PcreqMessage other = CodeHelpers.checkCast(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcreq.message.PcreqMessage.class, obj);
        if (other == null) {
            return false;
        }
        if (!Objects.equals(thisObj.getVersion(), other.getVersion())) {
            return false;
        }
        if (!Objects.equals(thisObj.getMonitoringRequest(), other.getMonitoringRequest())) {
            return false;
        }
        if (!Objects.equals(thisObj.getRequests(), other.getRequests())) {
            return false;
        }
        if (!Objects.equals(thisObj.getSvec(), other.getSvec())) {
            return false;
        }
        return thisObj.augmentations().equals(other.augmentations());
    }
    
    /**
     * Default implementation of {@link Object#toString()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent string
     * representations across all implementations.
     *
     * @param obj Object for which to generate toString() result.
     * @return {@link String} value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static String bindingToString(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcreq.message.@NonNull PcreqMessage obj) {
        final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("PcreqMessage");
        CodeHelpers.appendValue(helper, "monitoringRequest", obj.getMonitoringRequest());
        CodeHelpers.appendValue(helper, "requests", obj.getRequests());
        CodeHelpers.appendValue(helper, "svec", obj.getSvec());
        CodeHelpers.appendValue(helper, "version", obj.getVersion());
        CodeHelpers.appendAugmentations(helper, "augmentation", obj);
        return helper.toString();
    }
    
    /**
     * Return requests, or {@code null} if it is not present.
     *
     * @return {@code List<Requests>} requests, or {@code null} if it is not present.
     *
     */
    @Nullable List<Requests> getRequests();
    
    /**
     * Return requests, or an empty list if it is not present.
     *
     * @return {@code List<Requests>} requests, or an empty list if it is not present.
     *
     */
    default @NonNull List<Requests> nonnullRequests() {
        return CodeHelpers.nonnull(getRequests());
    }
    
    /**
     * Return svec, or {@code null} if it is not present.
     *
     * @return {@code List<Svec>} svec, or {@code null} if it is not present.
     *
     */
    @Nullable List<Svec> getSvec();
    
    /**
     * Return svec, or an empty list if it is not present.
     *
     * @return {@code List<Svec>} svec, or an empty list if it is not present.
     *
     */
    default @NonNull List<Svec> nonnullSvec() {
        return CodeHelpers.nonnull(getSvec());
    }
    
    /**
     * Return monitoringRequest, or {@code null} if it is not present.
     *
     * @return {@code MonitoringRequest} monitoringRequest, or {@code null} if it is not present.
     *
     */
    MonitoringRequest getMonitoringRequest();

}

